/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.BoletoResumoDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.time.LocalDate;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BloquetoService
extends ReadOnlyService<Bloqueto, Long> {
    private static final int MAX_DIGITOS_NOSSO_NUMERO = 17;
    private final EntidadeRepository entidadeRepository;
    private final BoletoRepository bloquetoRepository;
    private final ExercicioService exercicioService;
    private final ContextService contextService;
    private final CalculoAcrescimoService calculoAcrescimoService;

    @Autowired
    public BloquetoService(EntidadeRepository entidadeRepository, BoletoRepository bloquetoRepository, ExercicioService exercicioService, ContextService contextService, CalculoAcrescimoService calculoAcrescimoService) {
        this.entidadeRepository = entidadeRepository;
        this.bloquetoRepository = bloquetoRepository;
        this.exercicioService = exercicioService;
        this.contextService = contextService;
        this.calculoAcrescimoService = calculoAcrescimoService;
    }

    public Bloqueto findByBloqueto(Long bloqueto) {
        Entidade entidade = this.entidadeRepository.findByEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return this.bloquetoRepository.findByBloqueto(entidade.getId(), exercicio, bloqueto);
    }

    public ValueBlockDashDTO getQuantidadeBoletosGerados(LocalDate data) {
        return new ValueBlockDashDTO(this.bloquetoRepository.getQuantidadeBoletosGerados(data));
    }

    public Bloqueto save(Bloqueto boleto) {
        boleto.atualizaValoresBoleto();
        return (Bloqueto)this.bloquetoRepository.save((Object)boleto);
    }

    public BoletoResumoDTO findBoletoResumoById(Long id) {
        Bloqueto boleto = (Bloqueto)this.bloquetoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o boleto com id: %d", id)));
        return BoletoResumoDTO.from((Bloqueto)boleto);
    }

    public Page<BoletoDTO> findBoleto(FiltroBoletoDTO filtroBoletoDTO, Pageable pageable) {
        return this.bloquetoRepository.findBoleto(this.contextService.getEntidadePrincipal(), filtroBoletoDTO, pageable);
    }

    public Optional<Bloqueto> findByNossoNumero(String nossoNumero) {
        return this.bloquetoRepository.findByNossoNumero(nossoNumero);
    }

    public BoletoDTO getBoletoLoteManualPorTermoEMesmoCadastroPagamento(String termo, Long entidade, Long exercicioPagamento, Long boletoPagamentoOrigem) {
        Bloqueto boletoOrigem = this.bloquetoRepository.findByBloqueto(entidade, exercicioPagamento, boletoPagamentoOrigem);
        Bloqueto boletoNovo = this.findBoletoByCamposBoleto(termo, boletoOrigem.getEntidade(), boletoOrigem.getCadastroGeral().getCadastroGeral(), boletoOrigem.getCadastroGeral().getTipoCadastro());
        this.validacaoBoleto(boletoNovo);
        return BoletoDTO.from((Bloqueto)boletoNovo);
    }

    public BoletoDTO getBoletoLoteManualPorTermo(String termo) {
        Bloqueto boleto = this.findBoletoByCamposBoleto(termo);
        this.validacaoBoleto(boleto);
        return BoletoDTO.from((Bloqueto)boleto);
    }

    private void validacaoBoleto(Bloqueto boleto) {
        if (boleto.getPago().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel adicionar um boleto pago.");
        }
        if (boleto.validaSeBoletoComParcelaPaga()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel adicionar um boleto com parcelas pagas.");
        }
        if (boleto.validaSePossuiDescontoSemMotivoDeducao()) {
            throw new EloValidationException("Boleto com desconto sem motivo informado, favor corrig\u00ed-lo.");
        }
    }

    public Bloqueto findBoletoByCamposBoleto(String termo, Long entidade, Long cadastroGeral, TipoCadastro tipoCadastro) {
        String termoSemEspacos = termo.replaceAll("\\s+", "");
        boolean padraoNumerico = Pattern.compile("\\d+").matcher(termoSemEspacos).matches();
        if (!padraoNumerico) {
            throw new EloValidationException("Termo inv\u00e1lido para pesquisa.");
        }
        return (Bloqueto)this.bloquetoRepository.findByCodigoBarrasOuLinhaDigitavelComMesmoCadastroPagamento(termo, entidade, cadastroGeral, tipoCadastro).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado o boleto informado."));
    }

    public Bloqueto findBoletoByCamposBoleto(String termo) {
        Optional boleto;
        String termoSemEspacos = termo.replaceAll("\\s+", "");
        boolean padraoBoletoAno = Pattern.compile("\\d+/\\d+").matcher(termoSemEspacos).matches();
        boolean padraoNumerico = Pattern.compile("\\d+").matcher(termoSemEspacos).matches();
        if (!padraoBoletoAno && !padraoNumerico) {
            throw new EloValidationException("Termo inv\u00e1lido para pesquisa.");
        }
        if (padraoBoletoAno) {
            String[] boletoAno = termoSemEspacos.split("/");
            boleto = this.bloquetoRepository.findByBloquetoAndExercicioBloqueto(Long.valueOf(boletoAno[0]), Long.valueOf(boletoAno[1]));
        } else {
            boleto = termoSemEspacos.length() <= 17 ? this.findByNossoNumero(termoSemEspacos) : this.bloquetoRepository.findByCodigoBarrasOuLinhaDigitavel(termoSemEspacos);
        }
        return (Bloqueto)boleto.orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado o boleto informado."));
    }

    public void calcularAcrescimos(Bloqueto boleto, LocalDate dataReferencia) {
        boleto.getDebitos().forEach(boletoDebito -> {
            if (Boolean.TRUE.equals(boleto.getUtilizaValorBloqueto())) {
                boletoDebito.setValorPrincipalAcrescimo(boletoDebito.getValorPrincipal());
                boletoDebito.setValorJurosAcrescimo(boletoDebito.getValorJuros());
                boletoDebito.setValorMultaAcrescimo(boletoDebito.getValorMulta());
                boletoDebito.setValorCorrecaoAcrescimo(boletoDebito.getValorCorrecao());
            } else {
                this.calcularAcrescimosBoletoDebito(boleto.getFormaPagamento(), dataReferencia, boletoDebito);
            }
        });
    }

    private void calcularAcrescimosBoletoDebito(Long formaPagamento, LocalDate dataReferencia, BoletoDebito boletoDebito) {
        DebitoParcela debitoParcela = boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela();
        AcrescimoDTO acrescimo = new AcrescimoDTO();
        acrescimo.setEntidade(boletoDebito.getId().getEntidade());
        acrescimo.setExercicio(boletoDebito.getId().getDebitoParcelaTributo().getExercicio());
        acrescimo.setDataLancamento(debitoParcela.getDataLancamento());
        acrescimo.setDataPrimeiraParcela(debitoParcela.getDebito().getDataPrimeiraParcela());
        acrescimo.setDataReferencia(dataReferencia);
        acrescimo.setDataVencimento(debitoParcela.getDataVencimento());
        acrescimo.setDataVencimentoOriginal(debitoParcela.getDataVencimento());
        acrescimo.setFormaCorrecao(debitoParcela.getDebito().getFormaCorrecao().getId());
        acrescimo.setParcelado(debitoParcela.getDebito().getParcelado());
        acrescimo.setSituacaoLegal(debitoParcela.getSituacaoLegal());
        acrescimo.setTributo(boletoDebito.getId().getDebitoParcelaTributo().getTributo());
        acrescimo.setValor(boletoDebito.getValorPrincipal());
        acrescimo.setFormaPagamento(formaPagamento);
        DividaDTO divida = new DividaDTO();
        divida.setId(debitoParcela.getDebito().getDivida().getId());
        divida.setExercicio(boletoDebito.getId().getDebitoParcelaTributo().getExercicio());
        divida.setDivida(debitoParcela.getDebito().getDivida().getDivida());
        divida.setEntidade(boletoDebito.getId().getDebitoParcelaTributo().getEntidade());
        acrescimo.setDivida(divida);
        acrescimo.setCalculaValorDesconto(Boolean.FALSE);
        this.calculoAcrescimoService.calculaAcrescimos(acrescimo);
        boletoDebito.setValorPrincipalAcrescimo(acrescimo.getValor());
        boletoDebito.setValorJurosAcrescimo(acrescimo.getValorJuros());
        boletoDebito.setValorMultaAcrescimo(acrescimo.getValorMulta());
        boletoDebito.setValorCorrecaoAcrescimo(acrescimo.getValorCorrecao());
    }
}

