/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.keycloak.adapters.springsecurity.KeycloakSecurityComponents;
import org.keycloak.adapters.springsecurity.client.KeycloakClientRequestFactory;
import org.keycloak.adapters.springsecurity.config.KeycloakWebSecurityConfigurerAdapter;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@KeycloakConfiguration
@EnableWebSecurity
@ComponentScan(basePackageClasses={KeycloakSecurityComponents.class})
public class TributosSecurityConfiguration
extends KeycloakWebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    @Autowired
    public KeycloakClientRequestFactory keycloakClientRequestFactory;
    @Value(value="${keycloak.configurationFile}")
    private Resource keycloakConfigurationFile;

    public TributosSecurityConfiguration() {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.keycloakAuthenticationProvider());
    }

    @Bean
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new RegisterSessionAuthenticationStrategy((SessionRegistry)new SessionRegistryImpl());
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/public/*"})).antMatchers(new String[]{"/error"})).antMatchers(new String[]{"/actuator/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/appwebconf/texto-apresentacao"})).antMatchers(HttpMethod.GET, new String[]{"/api/bloqueto/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/bloqueto/imprime**"})).antMatchers(HttpMethod.GET, new String[]{"/api/entidades/principal/entidade"})).antMatchers(HttpMethod.GET, new String[]{"/api/entidades/principal/brasao"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-imobiliario/imprimir-espelho**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/cadastros-com-carnes/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/getCadastros/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/getCadastro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-mobiliario/imprimir-espelho**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/agrupados/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitoscarne**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitoscarne/agrupado-forma-pagamento/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/carne/gera-carne-forma-pagamento"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos/autenticidade/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos-tipos/*/tipos-cadastro"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentofinalidade/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imobiliario-avaliacao**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimirdebitos/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimir-situacaocadastral/cadastro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimir-situacaocadastral/cnpjcpf/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/laudoavaliacao/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/modulos/ativos"})).antMatchers(HttpMethod.GET, new String[]{"/api/parcelamentos/*/imprimir-contrato"})).antMatchers(HttpMethod.GET, new String[]{"/api/parametros-gerais/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/certidaoquitacaoitbi/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/registro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/relatorios/avulso-completo/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/modulos/ativos"})).antMatchers(HttpMethod.POST, new String[]{"/api/bloqueto/gera-por-data-pagamento"})).antMatchers(HttpMethod.POST, new String[]{"/api/carne"})).antMatchers(HttpMethod.POST, new String[]{"/api/certidao"})).antMatchers(HttpMethod.POST, new String[]{"/api/data-vencimento-boleto/em-atraso"})).antMatchers(HttpMethod.POST, new String[]{"/api/imprimirdocumento"})).antMatchers(HttpMethod.POST, new String[]{"/api/documentos/*/gerar"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/documento/*"})).antMatchers(HttpMethod.POST, new String[]{"/api/cadastros-avulso"})).antMatchers(HttpMethod.POST, new String[]{"/api/debitos"})).antMatchers(HttpMethod.POST, new String[]{"/api/debitos/verificar-pagos"})).antMatchers(HttpMethod.POST, new String[]{"/api/mobile/bloqueto/gera"})).antMatchers(HttpMethod.GET, new String[]{"/api/tipos-requerimentos/com-taxas/assunto/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/pessoa/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/cadastro-mobiliario/alteracao-cadastral"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/*/parcelas/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/integracao-contabil/lote/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/integracao-contabil/patrimonial/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/totalacesso"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).authorizeRequests().anyRequest()).authenticated().and()).anonymous().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http401UnauthorizedEntryPoint());
    }

    @Bean
    public Keycloak keycloakAdminClient(KeycloakDeployment deployment) {
        ResteasyClient restEasy = new ResteasyClientBuilder().connectionPoolSize(20).socketTimeout(30L, TimeUnit.SECONDS).establishConnectionTimeout(1L, TimeUnit.MINUTES).connectionCheckoutTimeout(30L, TimeUnit.SECONDS).build();
        return KeycloakBuilder.builder().clientId(deployment.getResourceName()).clientSecret(deployment.getResourceCredentials().get("secret").toString()).realm(deployment.getRealm()).grantType("client_credentials").serverUrl(deployment.getAuthServerBaseUrl()).resteasyClient(restEasy).build();
    }

    @Bean
    public KeycloakDeployment keycloakDeployment() throws IOException {
        return KeycloakDeploymentBuilder.build((InputStream)this.keycloakConfigurationFile.getInputStream());
    }

    @Bean
    public RealmResource keycloakRealmClient(Keycloak keycloakClient) throws IOException {
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)this.keycloakConfigurationFile.getInputStream());
        return keycloakClient.realm(deployment.getRealm());
    }
}

