/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.LoteIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SolicitacaoIntegracaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoContabilService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoPatrimonialService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.Callable;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-contabil"})
public class IntegracaoContabilResource {
    private final IntegracaoContabilService integracaoContabilService;
    private final IntegracaoPatrimonialService integracaoPatrimonialService;
    private final TarefaAssincronaService tarefaAssincronaService;

    public IntegracaoContabilResource(IntegracaoContabilService integracaoContabilService, IntegracaoPatrimonialService integracaoPatrimonialService, TarefaAssincronaService tarefaAssincronaService) {
        this.integracaoContabilService = integracaoContabilService;
        this.integracaoPatrimonialService = integracaoPatrimonialService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }

    @GetMapping(value={"/lote/{id}"})
    public ResponseEntity<LoteIntegracaoContabilDTO> load(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.integracaoContabilService.loadInformacoesLote(id));
    }

    @PostMapping(value={"/integrar-lote"})
    public ResponseEntity<LoteIntegracaoContabil> integrarLote(@RequestBody @Valid SolicitacaoIntegracaoDTO lote) {
        return ResponseEntity.ok((Object)this.integracaoContabilService.integrarLote(lote));
    }

    @PostMapping(value={"/integrar-datas"})
    public Callable<Void> integrarDatas(@RequestBody List<LocalDate> datasSelecionadas) {
        return () -> {
            String userAise = SecurityUtils.getUserAise();
            String userId = SecurityUtils.getUserId().toString();
            this.tarefaAssincronaService.validarTarefaIntegracaoContabilProcessandoComMesmaData(datasSelecionadas);
            this.integracaoContabilService.integrarDatasAssincrono(datasSelecionadas, userAise, userId);
            return null;
        };
    }

    @GetMapping(value={"/patrimonial/{id}"})
    public ResponseEntity<IntegracaoPatrimonialContabilidadeDTO> loadIntegracaoPatrimonial(@PathVariable(value="id") Long id) {
        return this.integracaoPatrimonialService.findById((Serializable)id).map(IntegracaoPatrimonial::toDto).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

