/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.parcelamento.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroEstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoIdDTO;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepositoryCustom;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ParcelamentoRepositoryImpl
implements ParcelamentoRepositoryCustom {
    private static final String DEBITO_ORIGEM = "br/com/elotech/tributos/repository/parcelamento-debito-origem.sql";
    private static final String DEBITO_NOVO = "br/com/elotech/tributos/repository/parcelamento-debito-novo.sql";
    private static final String DEBITO_PARCELAS = "br/com/elotech/tributos/repository/parcelamento-debito-parcelas.sql";
    private static final String PARCELAMENTO_QUITADO = "br/com/elotech/tributos/repository/parcelamento-quitado.sql";
    private static final String PARCELAMENTO_ESTORNO_LOTES = "br/com/elotech/tributos/repository/find-estorno-parcelamento-em-lote.sql";
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ParcelamentoRepositoryImpl(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_ORIGEM);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_NOVO);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_PARCELAS);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoParcelasDTO.class));
    }

    public Boolean parcelamentoComDebitosQuitados(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)PARCELAMENTO_QUITADO);
        return !this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoIdDTO.class)).isEmpty();
    }

    public List<EstornoParcelamentoEmLoteDTO> findParcelamentosParaEstornoEmLote(FiltroEstornoParcelamentoEmLoteDTO filtroEstornoParcelamentoEmLoteDTO, Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)PARCELAMENTO_ESTORNO_LOTES).replace("$[FiltroDesfazerParcelamento]", filtroEstornoParcelamentoEmLoteDTO.buildFiltroEstornoParcelamentoEmLoteDTO()).replace("$[FiltroParcelasDesfazerParcelamento]", filtroEstornoParcelamentoEmLoteDTO.buildParcelaVencidaNoventaDias()).replace("$[FiltroParcelasVencer]", filtroEstornoParcelamentoEmLoteDTO.buildParcelaAvencer());
        MapSqlParameterSource parametros = filtroEstornoParcelamentoEmLoteDTO.getParameterSource(entidade, exercicio);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parametros, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoParcelamentoEmLoteDTO.class));
    }
}

