/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.core.utils.ListUtils;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialCustomRepository;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.RsqlOperatorUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class IntegracaoPatrimonialRepositoryImpl
implements IntegracaoPatrimonialCustomRepository {
    private static final String CONSULTA_CANCELAMENTOS_DIVERSOS = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-cancelamentos-diversos.sql";
    private static final String CONSULTA_ESTORNO_CANCELAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-estorno-cancelamentos.sql";
    private static final String CONSULTA_INSCRICOES_EM_DIVIDA_ATIVA = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-inscricoes-em-divida-ativa.sql";
    private static final String CONSULTA_INSCRICOES_NO_EXERCICIO = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-inscricoes-no-exercicio.sql";
    private static final String CONSULTA_ISENCOES_LANCAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-isencoes-lancamentos.sql";
    private static final String CONSULTA_ACRESCIMOS_PARCELAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-acrescimos-parcelamentos.sql";
    private static final String CONSULTA_DESCONTOS_PARCELAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-descontos-parcelamentos.sql";
    private static final String CONSULTA_ESTORNO_ACRESCIMOS_PARCELAMENTOS_PARA_PROXIMA_SUBDIVIDA = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-estorno-acrescimos-parcelamentos-para-proxima-subdivida.sql";
    private static final String CONSULTA_ESTORNO_ACRESCIMOS_PARCELAMENTOS_PARA_SUBDIVIDA_ORIGEM = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-estorno-acrescimos-parcelamentos-para-subdivida-origem.sql";
    private static final String CONSULTA_ESTORNO_DESCONTOS_PARCELAMENTOS_PARA_PROXIMA_SUBDIVIDA = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-estorno-descontos-parcelamentos-para-proxima-subdivida.sql";
    private static final String CONSULTA_ESTORNO_DESCONTOS_PARCELAMENTOS_PARA_SUBDIVIDA_ORIGEM = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-estorno-descontos-parcelamentos-para-subdivida-origem.sql";
    private static final String CONSULTA_REABILITACAO_ACRESCIMOS_PARCELAMENTO_ONDE_ESTORNO_INSCREVEU_PROXIMA_SUBDIVIDA = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-reabilitacao-acrescimos-parcelamento-onde-estorno-inscreveu-proxima-subdivida.sql";
    private static final String CONSULTA_REABILITACAO_ACRESCIMOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_SUBDIVIDA_ORIGEM = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-reabilitacao-acrescimos-parcelamento-onde-estorno-reinscreveu-subdivida-origem.sql";
    private static final String CONSULTA_REABILITACAO_DESCONTOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_PROXIMA_SUBDIVIDA = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-reabilitacao-descontos-parcelamento-onde-estorno-reinscreveu-proxima-subdivida.sql";
    private static final String CONSULTA_REABILITACAO_DESCONTOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_SUBDIVIDA_ORIGEM = "br/com/elotech/tributos/repository/integracaocontabil/patrimonial/consulta-reabilitacao-descontos-parcelamento-onde-estorno-reinscreveu-subdivida-origem.sql";
    private static final String CONSULTA_INTEGRACAO_PATRIMONIAL_TOTAL = "select sum(ii.valor) as valorTotal from integracaopatrimonial ip inner join itemintegracaopatrimonial ii on ip.id = ii.idintegracaopatrimonial";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public IntegracaoPatrimonialRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private List<ItemIntegracaoPatrimonialDTO> getMovimentacoes(List<LocalDate> datasMovimento, String sqlFileName) {
        String sql = FileUtils.readResourceAsString((String)sqlFileName);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("datasMovimento", datasMovimento.stream().map(Date::valueOf).collect(Collectors.toList()));
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ItemIntegracaoPatrimonialDTO.class));
    }

    public List<ItemIntegracaoPatrimonialDTO> findInscricoesDiversas(List<LocalDate> datasMovimento) {
        return ListUtils.union((List)this.getInscricoesNoExercicio(datasMovimento), (List)this.getInscrioesEmDividaAtiva(datasMovimento));
    }

    private List<ItemIntegracaoPatrimonialDTO> getInscricoesNoExercicio(List<LocalDate> datasMovimento) {
        return this.getMovimentacoes(datasMovimento, CONSULTA_INSCRICOES_NO_EXERCICIO);
    }

    private List<ItemIntegracaoPatrimonialDTO> getInscrioesEmDividaAtiva(List<LocalDate> datasMovimento) {
        List inscricoesDividaAtiva = this.getMovimentacoes(datasMovimento, CONSULTA_INSCRICOES_EM_DIVIDA_ATIVA);
        List baixaInscricoesNoExercicio = inscricoesDividaAtiva.stream().map(ItemIntegracaoPatrimonialDTO::toBaixaInscricaoNoExercicio).collect(Collectors.toList());
        return ListUtils.union((List)inscricoesDividaAtiva, baixaInscricoesNoExercicio);
    }

    public List<ItemIntegracaoPatrimonialDTO> findCancelamentos(List<LocalDate> datasMovimento) {
        List cancelamentosDiversos = this.getMovimentacoes(datasMovimento, CONSULTA_CANCELAMENTOS_DIVERSOS);
        List isencoes = this.getMovimentacoes(datasMovimento, CONSULTA_ISENCOES_LANCAMENTOS);
        return ListUtils.union((List)cancelamentosDiversos, (List)isencoes);
    }

    public List<ItemIntegracaoPatrimonialDTO> findEstornoCancelamentos(List<LocalDate> datasMovimento) {
        return this.getMovimentacoes(datasMovimento, CONSULTA_ESTORNO_CANCELAMENTOS);
    }

    public List<ItemIntegracaoPatrimonialDTO> findParcelamentos(List<LocalDate> datasMovimento) {
        List acrescimosParcelamento = this.getMovimentacoes(datasMovimento, CONSULTA_ACRESCIMOS_PARCELAMENTOS);
        List descontosParcelamento = this.getMovimentacoes(datasMovimento, CONSULTA_DESCONTOS_PARCELAMENTOS);
        return ListUtils.union((List)acrescimosParcelamento, (List)descontosParcelamento);
    }

    public List<ItemIntegracaoPatrimonialDTO> findEstornosParcelamentos(List<LocalDate> datasMovimento) {
        List estornoAcrescimosSubOrigem = this.getMovimentacoes(datasMovimento, CONSULTA_ESTORNO_ACRESCIMOS_PARCELAMENTOS_PARA_SUBDIVIDA_ORIGEM);
        List estornoDescontosSubOrigem = this.getMovimentacoes(datasMovimento, CONSULTA_ESTORNO_DESCONTOS_PARCELAMENTOS_PARA_SUBDIVIDA_ORIGEM);
        List estornoAcrescimosProximaSub = this.getMovimentacoes(datasMovimento, CONSULTA_ESTORNO_ACRESCIMOS_PARCELAMENTOS_PARA_PROXIMA_SUBDIVIDA);
        List estornoDescontosProximaSub = this.getMovimentacoes(datasMovimento, CONSULTA_ESTORNO_DESCONTOS_PARCELAMENTOS_PARA_PROXIMA_SUBDIVIDA);
        return ListUtils.union((List)ListUtils.union((List)estornoAcrescimosSubOrigem, (List)estornoDescontosSubOrigem), (List)ListUtils.union((List)estornoAcrescimosProximaSub, (List)estornoDescontosProximaSub));
    }

    public List<ItemIntegracaoPatrimonialDTO> findReabilitacoesParcelamentos(List<LocalDate> datasMovimento) {
        List reabilitacaoAcrescimosSubOrigem = this.getMovimentacoes(datasMovimento, CONSULTA_REABILITACAO_ACRESCIMOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_SUBDIVIDA_ORIGEM);
        List reabilitacaoDescontosSubOrigem = this.getMovimentacoes(datasMovimento, CONSULTA_REABILITACAO_DESCONTOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_SUBDIVIDA_ORIGEM);
        List reabilitacaoAcrescimosProximaSub = this.getMovimentacoes(datasMovimento, CONSULTA_REABILITACAO_ACRESCIMOS_PARCELAMENTO_ONDE_ESTORNO_INSCREVEU_PROXIMA_SUBDIVIDA);
        List reabilitacaoDescontosProximaSub = this.getMovimentacoes(datasMovimento, CONSULTA_REABILITACAO_DESCONTOS_PARCELAMENTO_ONDE_ESTORNO_REINSCREVEU_PROXIMA_SUBDIVIDA);
        return ListUtils.union((List)ListUtils.union((List)reabilitacaoAcrescimosSubOrigem, (List)reabilitacaoDescontosSubOrigem), (List)ListUtils.union((List)reabilitacaoAcrescimosProximaSub, (List)reabilitacaoDescontosProximaSub));
    }

    public TotalizadorIntegracaoPatrimonialDTO getTotalSearch(String search) {
        String parameter;
        int index;
        List filterId = RsqlUtils.getFieldValues((String)search, (String)"id");
        List filterData = RsqlUtils.getFieldValues((String)search, (String)"dataMovimento");
        List filterSituacao = RsqlUtils.getFieldValues((String)search, (String)"situacaoIntegracaoPatrimonial");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<String> whereClauses = new ArrayList<String>();
        for (index = 0; index < filterId.size(); ++index) {
            parameter = String.format("id%s", index);
            Long id = Long.valueOf(((AttributeGetterResult)filterId.get(index)).getValue());
            whereClauses.add(String.format(" ip.id %s :%s ", ((AttributeGetterResult)filterId.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)id);
        }
        for (index = 0; index < filterData.size(); ++index) {
            parameter = String.format("dataMovimento%s", index);
            Date date = Date.valueOf(DateUtils.stringToLocalDate((String)((AttributeGetterResult)filterData.get(index)).getValue()));
            whereClauses.add(String.format("ip.dataMovimento %s :%s ", ((AttributeGetterResult)filterData.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)date);
        }
        for (index = 0; index < filterSituacao.size(); ++index) {
            parameter = String.format("situacao%s", index);
            SituacaoIntegracaoContabil situacao = SituacaoIntegracaoContabil.valueOf((String)((AttributeGetterResult)filterSituacao.get(index)).getValue());
            whereClauses.add(String.format(" ip.situacaoIntegracaoPatrimonial %s :%s ", ((AttributeGetterResult)filterSituacao.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)situacao.name());
        }
        String sqlWithParameters = whereClauses.isEmpty() ? CONSULTA_INTEGRACAO_PATRIMONIAL_TOTAL : String.format("%s where %s", CONSULTA_INTEGRACAO_PATRIMONIAL_TOTAL, String.join((CharSequence)" and ", whereClauses));
        String sql = RsqlOperatorUtils.replaceOperatorsRsqlToSql((String)sqlWithParameters);
        BigDecimal valorTotal = (BigDecimal)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getBigDecimal("valorTotal"));
        return new TotalizadorIntegracaoPatrimonialDTO(valorTotal);
    }
}

