/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.AvaliacaoDTO;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class IntegracaoItbiRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public IntegracaoItbiRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<Map<String, Object>> findAllLogradouro() {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-logradouro.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllTipoLogradouro() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-tipologradouro.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllBairro() {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-bairro.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllCidade() {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-cidade.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllTipoItbi() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        return this.jdbcTemplate.queryForList("SELECT IDTIPOITBI AS \"codigo\", descricao as \"descricao\" FROM TRIBTIPOITBI ORDER BY IDTIPOITBI", (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllTipoVinculo() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-vinculo.sql"));
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllCadastros(TipoCadastro tipoCadastro, Optional<LocalDate> since) {
        String sqlPath = TipoCadastro.IMOBILIARIO.equals((Object)tipoCadastro) ? "br/com/elotech/tributos/repository/itbi-cadastroimobiliario.sql" : "br/com/elotech/tributos/repository/itbi-cadastrorural.sql";
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)sqlPath));
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        if (since.isPresent()) {
            sql.append(" AND ( ").append("(CG.DATAINCLUSAO >= :DATABASE) OR ").append("(CG.DATAALTERACAO >= :DATABASE) OR ").append("(CG.DATAEXCLUSAOLOGICA >= :DATABASE) OR ").append("(CG.DATARESTAURACAOLOGICA >= :DATABASE) ").append(" ) ");
            parameterSource.addValue("DATABASE", (Object)Date.valueOf(since.get()), 91);
        } else {
            sql.append(" AND CG.EXCLUSAOLOGICA = 'N' ");
        }
        sql.append(" ORDER BY CG.IDKEY ");
        return this.jdbcTemplate.queryForList(sql.toString(), (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllProprietariosPorTipoCadastro(Optional<LocalDate> since, TipoCadastro tipoCadastro) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/itbi-proprietario.sql"));
        parameterSource.addValue("tipoCadastro", (Object)tipoCadastro.getValue());
        if (since.isPresent()) {
            sql.append(" AND ( ").append("(CG.DATAINCLUSAO >= :DATABASE) OR ").append("(CG.DATAALTERACAO >= :DATABASE) OR ").append("(CG.DATAEXCLUSAOLOGICA >= :DATABASE) OR ").append("(CG.DATARESTAURACAOLOGICA >= :DATABASE) ").append(" ) ");
            parameterSource.addValue("DATABASE", (Object)Date.valueOf(since.get()), 91);
        } else {
            sql.append(" AND CG.EXCLUSAOLOGICA = 'N' ");
        }
        sql.append(" ORDER BY CG.IDKEY ");
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)parameterSource, (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Map<String, Object>> findAllTipoSegmento() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        return this.jdbcTemplate.queryForList("SELECT SEG.TIPOSEGMENTO AS \"id\", SEG.DESCRICAO as \"descricao\" FROM TRIBTIPOSEGMENTO SEG ORDER BY SEG.TIPOSEGMENTO", (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> findAllParamentrosItbi() {
        EmptySqlParameterSource parameterSource = new EmptySqlParameterSource();
        return this.jdbcTemplate.queryForList("SELECT TPI.PARAMETROITBI AS \"id\", TPI.DESCRICAO as \"descricao\", CASE WHEN COALESCE(TPI.ATIVO, 'N') = 'S' THEN 'true' ELSE 'false' END \"ativo\",TPI.ALIQUOTA as \"aliquotaNormal\", TPI.ALIQUOTAFINANC as \"aliquotaFinanciado\", TPI.ALIQUOTAFINANCAVISTA as \"aliquotaFinanciadoAVista\", TPI.ALIQUOTAANUENCIA as \"aliquotaAnuencia\"  FROM TRIBPARAMETROITBI TPI ORDER BY TPI.PARAMETROITBI", (SqlParameterSource)parameterSource);
    }

    public List<AvaliacaoDTO> findAllLaudoAvaliacao(Long tipoCadastro, Long cadastroGeral) {
        String sql = "(SELECT DISTINCT A.IDRECIBOAVALIACAO AS id, A.DATA AS dataLancamento, A.VALORVENALFINAL AS valorTransacaoAvaliacao \nFROM TRIBAVALIACAOITBI A INNER JOIN TRIBRECIBOITBICADASTRO B ON A.IDRECIBOAVALIACAO = B.IDRECIBOAVALIACAO\nLEFT JOIN TRIBDOCUMENTO C\nON A.DOC_TIPO = C.TIPODOCUMENTO\nAND A.DOC_EXERCICIO = C.EXERCICIO\nAND A.DOC_DOCUMENTO = C.DOCUMENTO\nWHERE B.TIPOCADASTRO = :TIPOCADASTRO AND B.CADASTROGERAL = :CADASTROGERAL\nAND COALESCE(C.CANCELADO, 'N') = 'N') UNION ALL (SELECT ITBI.IDSEQUENCIA as id, ITBI.DATALANCAMENTO as dataLancamento, coalesce(ITBI.BASECALCULO, 0) + coalesce(ITBI.BASECALCULOFINANCIADO, 0) as valorTransacaoAvaliacao FROM TRIBIMOBILIARIOITBI ITBI WHERE ITBI.TIPOCADASTRO = :TIPOCADASTRO AND ITBI.CADASTROGERAL = :CADASTROGERAL AND TRANSFERIDO = 'T') ORDER BY dataLancamento DESC, valorTransacaoAvaliacao DESC ";
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("TIPOCADASTRO", (Object)tipoCadastro, 2);
        parameterSource.addValue("CADASTROGERAL", (Object)cadastroGeral, 2);
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(AvaliacaoDTO.class);
        return this.jdbcTemplate.query("(SELECT DISTINCT A.IDRECIBOAVALIACAO AS id, A.DATA AS dataLancamento, A.VALORVENALFINAL AS valorTransacaoAvaliacao \nFROM TRIBAVALIACAOITBI A INNER JOIN TRIBRECIBOITBICADASTRO B ON A.IDRECIBOAVALIACAO = B.IDRECIBOAVALIACAO\nLEFT JOIN TRIBDOCUMENTO C\nON A.DOC_TIPO = C.TIPODOCUMENTO\nAND A.DOC_EXERCICIO = C.EXERCICIO\nAND A.DOC_DOCUMENTO = C.DOCUMENTO\nWHERE B.TIPOCADASTRO = :TIPOCADASTRO AND B.CADASTROGERAL = :CADASTROGERAL\nAND COALESCE(C.CANCELADO, 'N') = 'N') UNION ALL (SELECT ITBI.IDSEQUENCIA as id, ITBI.DATALANCAMENTO as dataLancamento, coalesce(ITBI.BASECALCULO, 0) + coalesce(ITBI.BASECALCULOFINANCIADO, 0) as valorTransacaoAvaliacao FROM TRIBIMOBILIARIOITBI ITBI WHERE ITBI.TIPOCADASTRO = :TIPOCADASTRO AND ITBI.CADASTROGERAL = :CADASTROGERAL AND TRANSFERIDO = 'T') ORDER BY dataLancamento DESC, valorTransacaoAvaliacao DESC ", (SqlParameterSource)parameterSource, (RowMapper)rowMapper);
    }
}

