/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PeticaoDividaAtivaParamLoader {
    private final EntidadeRepository entidadeRepository;
    private static final String PARAM_FORMAT = "%s=%s%n";

    public PeticaoDividaAtivaParamLoader(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    public String load(Long exercicio) {
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        return String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PDescUF", unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, "PExercicio", exercicio)).concat(String.format(PARAM_FORMAT, "PEhSegundaVia", "N")).concat(String.format(PARAM_FORMAT, "PCidade", this.getCidadeDescricao(entidadeprincipal.getCidade()))).concat(String.format(PARAM_FORMAT, "PCNPJ", StringUtils.defaultString((String)entidadeprincipal.getCnpj(), (String)""))).concat(String.format(PARAM_FORMAT, "PCPF", "")).concat(String.format(PARAM_FORMAT, "PFiltroRelatorio", "")).concat(String.format(PARAM_FORMAT, "PFiltroRelatorio2", "")).concat(String.format(PARAM_FORMAT, "PMask_CEP", "")).concat(String.format(PARAM_FORMAT, "PQuerCompromissario", "N"));
    }

    private String getCidadeDescricao(Cidade cidade) {
        if (!Optional.ofNullable(cidade).isPresent()) {
            return "";
        }
        return cidade.getDescricao();
    }
}

