/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.domain.TipoCalculo;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class SimulacaoCalculoJobListener
extends JobExecutionListenerSupport {
    private static final String JOB_TYPE = "jobType";
    private static final String ID_CALCULO = "idCalculo";
    private final NotificacaoClient notificacaoClient;
    private final CalculoService calculoService;
    private final CalculoTributoService calculoTributoService;
    private final CalculoExecucaoService calculoExecucaoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;

    public SimulacaoCalculoJobListener(NotificacaoClient notificacaoClient, CalculoService calculoService, CalculoTributoService calculoTributoService, CalculoExecucaoService calculoExecucaoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService) {
        this.notificacaoClient = notificacaoClient;
        this.calculoService = calculoService;
        this.calculoTributoService = calculoTributoService;
        this.calculoExecucaoService = calculoExecucaoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Calculo calculo = (Calculo)this.calculoService.findOne((Serializable)idCalculo);
        List<SituacaoCalculo> situacoesPassiveisSimulacao = Arrays.asList(SituacaoCalculo.GERANDO_SIMULACAO, SituacaoCalculo.ERRO_SIMULACAO, SituacaoCalculo.SIMULACAO_GERADA);
        if (!situacoesPassiveisSimulacao.contains(calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel processar a simula\u00e7\u00e3o de c\u00e1lculo com a situa\u00e7\u00e3o \"%s\".", calculo.getSituacao().getDescricao()));
        }
        calculo.setSituacao(SituacaoCalculo.GERANDO_SIMULACAO);
        calculo.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        this.calculoService.save((EloEntity)calculo, null);
        List tributos = this.getFormulasCompiladas(calculo);
        jobExecution.getExecutionContext().put("tributos", (Object)tributos);
        jobExecution.getExecutionContext().put("parametroIsencaoValorMinimo", (Object)this.findParametroIsencaoValorMinimo(calculo.getExercicio()));
        Notificacao notificacao = Notificacao.builder().title(String.format("Iniciada a simula\u00e7\u00e3o do c\u00e1lculo %d.", idCalculo)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoSimulacaoGeradaSeTodosCadastrosCalculados(idCalculo);
            notificacao.title(String.format("Finalizada a simula\u00e7\u00e3o do c\u00e1lculo %d com sucesso.", idCalculo)).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoCalculo(idCalculo, SituacaoCalculo.ERRO_SIMULACAO);
            notificacao.title(String.format("Ocorreu um erro na simula\u00e7\u00e3o do c\u00e1lculo %d.", idCalculo)).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    private List<CalculoTributo> getFormulasCompiladas(Calculo calculo) {
        Boolean traceAtivo = TipoCalculo.SIMPLES.equals((Object)calculo.getTipo());
        List tributos = this.findFormulas(calculo);
        for (CalculoTributo tributo : tributos) {
            CalculoBuildDTO calculoBuildDTO = this.calculoExecucaoService.getFormulaCompilada(tributo, traceAtivo);
            tributo.setCalculoBuildDTO(calculoBuildDTO);
        }
        return tributos;
    }

    private List<CalculoTributo> findFormulas(Calculo calculo) {
        List dividas = calculo.getDividas();
        List tributos = this.calculoTributoService.findByDividasAndExercicioJoinFetchScript(dividas, calculo.getExercicio());
        if (tributos.isEmpty()) {
            String ids = dividas.stream().map(divida -> divida.getDivida().toString()).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("N\u0101o foram encontradas f\u00f3rmulas para calcular os tributos da(s) d\u00edvida(s) %s no exerc\u00edcio de %d.", ids, calculo.getExercicio()));
        }
        return tributos;
    }

    private String findParametroIsencaoValorMinimo(Long exercicio) {
        ParametroEntidadeExercicio parametroIsencaoValorMinimo = this.parametroEntidadeExercicioService.findByExercicioAndModuloAndParametro(exercicio, ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue());
        if (Objects.isNull(parametroIsencaoValorMinimo)) {
            return null;
        }
        return parametroIsencaoValorMinimo.getValor();
    }
}

