/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoBatchReader
extends JdbcCursorItemReader<LancamentoCreditoConsultaDTO> {
    public LancamentoCreditoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws Exception {
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(1000);
        this.setName("simamLancamentoCreditoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoConsultaDTO.class));
        this.setSql("SELECT CASE WHEN (tcrt.tributavel = 'S') THEN 1 ELSE 2 END AS idTipoNaturezaCredito,  trt.classificacaoreceitatipo AS idTipoCredito,  1 AS idTipoOperacaoCredito,  tdp.datalancamento AS dtlancamento,  coalesce(tdpr.valororiginal, tdpr.valor) AS vlLancamento,  tdpr.iddebitoparcelareceita,  td.entidade,  tdpr.exercicio,  tgr.idkey as idDivida,  tdpr.guiarecolhimento AS divida,  td.formacorrecao FROM tribdebitoparcelareceita tdpr JOIN tribdebitoparcela tdp   ON tdp.entidade = tdpr.entidade  AND tdp.exercicio = tdpr.exercicio  AND tdp.tipocadastro = tdpr.tipocadastro  AND tdp.cadastrogeral = tdpr.cadastrogeral  AND tdp.guiarecolhimento = tdpr.guiarecolhimento  AND tdp.subdivida = tdpr.subdivida  AND tdp.parcela = tdpr.parcela JOIN tribdebito td   ON td.entidade = tdp.entidade  AND td.exercicio = tdp.exercicio  AND td.tipocadastro = tdp.tipocadastro  AND td.cadastrogeral = tdp.cadastrogeral  AND td.guiarecolhimento = tdp.guiarecolhimento  AND td.subdivida = tdp.subdivida JOIN tribguiarecolhimento tgr   ON td.entidade = tgr.entidade  AND td.exercicio = tgr.exercicio  AND td.guiarecolhimento = tgr.guiarecolhimento JOIN tribreceita tr   ON tr.receita = tdpr.receita  AND tr.exercicio = tdpr.exercicio JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita JOIN tribclassificacaoreceitatipo tcrt   ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo " + String.format("WHERE trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)   AND tdp.situacaolegal = 0   AND td.constituido = 'S'   AND tdp.datalancamento BETWEEN '%s' AND '%s'   AND NOT EXISTS (SELECT 1 FROM tcedebitolanccredito tdlc                   WHERE tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita) ", dataInicial.toString(), dataFinal.toString()) + "ORDER BY dtlancamento ASC, idTipoCredito ASC, idTipoNaturezaCredito ASC, idTipoOperacaoCredito ASC, exercicio ASC, divida ASC");
    }
}

