SELECT
  CASE
    WHEN TMC.TIPOCAMPO = 'P' THEN TMR.DESCRICAO
                             ELSE BS.DESCRICAORESPOSTA
  END AS SEGMENTORESPOSTA,
  SG.TIPOCADASTRO,
  SG.CADASTROGERAL,
  SG.SEQUENCIA,
  SG.TIPOSEGMENTO,
  TG.DESCRICAO,
  CASE
    WHEN (SSG.LANCAIMPOSTO IS NULL) OR (SSG.LANCAIMPOSTO    = 'S') THEN SG.AREACONSTRUIDA
                                                                   ELSE 0
  END AS AREACONSTRUIDALANCA,
  CASE
    WHEN (SSG.LANCAIMPOSTO = 'N') THEN SG.AREACONSTRUIDA
                                  ELSE 0
  END AS AREACONSTRUIDANAOLANCA,
  SG.AREACONSTRUIDA,
  SG.PRINCIPAL,
  BS.MODELO,
  TM.DESCRICAO AS DESCMODELO,
  BS.MODELOGRUPO,
  TMG.DESCRICAO AS DESCGRUPO,
  BS.MODELOCAMPO,
  TMC.DESCRICAO AS DESCCAMPO,
  BS.MODELORESPOSTA,
  TMR.DESCRICAO AS DESCRESPOSTA,
  TMC.TIPOCAMPO,
  BS.DESCRICAORESPOSTA,
  COALESCE(SG.AREACOBERTA,0)    AS AREACOBERTA,
  COALESCE(SG.AREADESCOBERTA,0) AS AREADESCOBERTA,
  SSG.DESCRICAO                 AS SITUACAOSEGMENTODESC
FROM TRIBIMOBILIARIOSEGMENTO SG
LEFT OUTER JOIN TRIBTIPOSEGMENTO TG
ON TG.TIPOSEGMENTO = SG.TIPOSEGMENTO
LEFT OUTER JOIN TRIBBOLETIMIMOBILIARIOSEGMENTO BS
ON BS.TIPOCADASTRO   = SG.TIPOCADASTRO
AND BS.CADASTROGERAL = SG.CADASTROGERAL
AND BS.SEQUENCIA     = SG.SEQUENCIA
LEFT OUTER JOIN TRIBMODELO TM
ON TM.MODELO = BS.MODELO
LEFT OUTER JOIN TRIBMODELOGRUPO TMG
ON TMG.MODELO       = BS.MODELO
AND TMG.MODELOGRUPO = BS.MODELOGRUPO
LEFT OUTER JOIN TRIBMODELOCAMPO TMC
ON TMC.MODELO       = BS.MODELO
AND TMC.MODELOGRUPO = BS.MODELOGRUPO
AND TMC.MODELOCAMPO = BS.MODELOCAMPO
LEFT OUTER JOIN TRIBMODELORESPOSTA TMR
ON TMR.MODELO          = BS.MODELO
AND TMR.MODELOGRUPO    = BS.MODELOGRUPO
AND TMR.MODELOCAMPO    = BS.MODELOCAMPO
AND TMR.MODELORESPOSTA = BS.MODELORESPOSTA
LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO CI
ON CI.TIPOCADASTRO   = SG.TIPOCADASTRO
AND CI.CADASTROGERAL = SG.CADASTROGERAL
LEFT OUTER JOIN TRIBCADASTROGERAL CG
ON CG.TIPOCADASTRO   = CI.TIPOCADASTRO
AND CG.CADASTROGERAL = CI.CADASTROGERAL
LEFT JOIN TRIBSITUACAOSEGMENTOIMOB SSG
ON SSG.IDSITUACAOSEGMENTO = SG.IDSITUACAOSEGMENTO
where SG.tipocadastro = :tipoCadastro
and SG.cadastrogeral = :cadastroGeral