select
       peticao.entidade,
       peticao.exercicio,
       peticao.tipodocumento as tipoDocumento,
       peticao.documento,
       cda.EXERCICIO as exercicioCertidao,
       cda.TIPODOCUMENTO as tipoDocumentoCertidao,
       tdt.descricao as descricaoTipoDocumentoCertidao,
       cda.documento as documentoCertidao,
       cda.dataemissao as dataEmissaoCertidao,
       cda.tipocadastro,
       cda.cadastrogeral,
       cda.pessoa,
       p.nome as nomeContribuinte,
       p.cnpj_cpf,
       cda.idkey as idDocumentoCertidao,
       coalesce( sum( tdida.valor ), 0 ) as valor,
       coalesce( sum( tdida.valorjuros ), 0 ) as valorJuros,
       coalesce( sum( tdida.valormulta ), 0 ) as valorMulta,
       coalesce( sum( tdida.valorcorrecao ), 0 ) as valorCorrecao
 from tribdocumentopeticaocda tdpc
  inner join TRIBDOCUMENTO peticao on tdpc.IDPETICAO = peticao.IDKEY
  inner join TRIBDOCUMENTO cda on tdpc.IDCERTIDAODIVIDAATIVA = cda.IDKEY
  inner join tribdocumentotipo tdt on cda.TIPODOCUMENTO = tdt.TIPODOCUMENTO
  inner join pessoa p on cda.PESSOA = p.PESSOA
  inner join TRIBDOCUMENTOITEMDIVIDAATIVA tdida
    on cda.ENTIDADE = tdida.ENTIDADE and
       cda.EXERCICIO = tdida.EXERCICIO and
       cda.TIPODOCUMENTO = tdida.TIPODOCUMENTO and
       cda.DOCUMENTO = tdida.DOCUMENTO
where tdpc.IDPETICAO = :idPeticao
group by
     cda.idKey,
     peticao.entidade,
     peticao.exercicio,
     peticao.tipodocumento,
     peticao.documento,
     cda.exercicio,
     cda.tipodocumento,
     tdt.descricao,
     cda.documento,
     cda.dataemissao,
     cda.tipocadastro,
     cda.cadastrogeral,
     cda.pessoa,
     p.nome,
     p.cnpj_cpf
 order by cda.documento, cda.exercicio
