/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.integracaocontabil.LoteItemIntegracaoContabil;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemIntegracaoContabilAgrupadoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemPagamentoIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.repository.integracaocontabil.LoteItemIntegracaoContabilRepository;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class LoteItemIntegracaoContabilService
extends CrudService<LoteItemIntegracaoContabil, Long> {
    private final LoteItemIntegracaoContabilRepository loteItemIntegracaoContabilRepository;

    public LoteItemIntegracaoContabilService(LoteItemIntegracaoContabilRepository loteItemIntegracaoContabilRepository) {
        this.loteItemIntegracaoContabilRepository = loteItemIntegracaoContabilRepository;
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensLotePagamento(Long entidade, Long exercicio, Long lote) {
        return this.loteItemIntegracaoContabilRepository.findItensLotePagamento(entidade, exercicio, lote);
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensEstornoPagamento(LocalDate dataEstorno) {
        return this.loteItemIntegracaoContabilRepository.findItensEstornoPagamento(dataEstorno);
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensReabilitacaoPagamento(LocalDate dataReabilitacao) {
        return this.loteItemIntegracaoContabilRepository.findItensReabilitacaoPagamento(dataReabilitacao);
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensEstornoCredito(LocalDate dataEstorno) {
        return this.loteItemIntegracaoContabilRepository.findItensEstornoCredito(dataEstorno);
    }

    public List<LoteItemIntegracaoContabilDTO> findItensIntegracao(Long idLote, TipoMovimento tipoMovimento) {
        List itensAgrupados = this.loteItemIntegracaoContabilRepository.findItensAgrupados(idLote);
        return itensAgrupados.stream().map(itemAgrupado -> this.buildItemIntegracao(itemAgrupado, tipoMovimento)).collect(Collectors.toList());
    }

    private LoteItemIntegracaoContabilDTO buildItemIntegracao(LoteItemIntegracaoContabilAgrupadoDTO itemAgrupado, TipoMovimento tipoMovimento) {
        LoteItemIntegracaoContabilDTO item = new LoteItemIntegracaoContabilDTO();
        item.setTributo(itemAgrupado.getTributo());
        item.setDescricaoTributo(itemAgrupado.getDescricaoTributo().trim());
        item.setClassificacao(ClassificacaoTributo.fromValue((String)itemAgrupado.getClassificacaoTributo()));
        item.setSituacaoLegal(SituacaoLegal.fromValue((Integer)itemAgrupado.getSituacaoLegal().intValue()));
        item.setTipoMovimento(tipoMovimento);
        item.setValorTributo(itemAgrupado.getValorTributo());
        if (itemAgrupado.getValorDeducao().compareTo(BigDecimal.ZERO) > 0) {
            item.setTipoOperacaoDeducao(itemAgrupado.getTipoOperacaoDeducao());
            item.setValorDeducao(itemAgrupado.getValorDeducao());
        }
        return item;
    }
}

