/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.GerarQrCodePixBBRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.GerarQrCodePixBBResponseDTO;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoBBService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoBBService.class);
    private final RestTemplate restTemplate;
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);

    public String gerarQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog();
        try {
            Validate.notNull((Object)bloqueto);
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s/arrecadacao-qrcodes?gw-dev-app-key=%s", this.getParametro(ParametroGeralEnum.BOLETO_BB_API_PIX_URL), devAppKey);
            GerarQrCodePixBBRequestDTO dto = GerarQrCodePixBBRequestDTO.from((Bloqueto)bloqueto);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", String.format("Bearer %s", this.getAccessToken()));
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest("POST to " + url + "\n" + this.mapper.writeValueAsString((Object)requestEntity));
            GerarQrCodePixBBResponseDTO response = (GerarQrCodePixBBResponseDTO)this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GerarQrCodePixBBResponseDTO.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            String string = response.getQrCode();
            return string;
        }
        catch (RestException e) {
            GerarQrCodePixBBResponseDTO dtoErros = this.converteErroResposta(e.getMessage());
            if (Objects.nonNull(dtoErros) && dtoErros.hasErro()) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private GerarQrCodePixBBResponseDTO converteErroResposta(String json) {
        try {
            return (GerarQrCodePixBBResponseDTO)this.mapper.readValue(json, GerarQrCodePixBBResponseDTO.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            return this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getAccessToken() throws JsonProcessingException {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTSECRET);
        String authorizationBase64 = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("Authorization", String.format("Basic %s", authorizationBase64));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        log.info("Get token request: " + this.mapper.writeValueAsString((Object)httpEntity));
        JsonNode response = (JsonNode)this.restTemplate.exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
        log.info("Token response: " + this.mapper.writeValueAsString((Object)response));
        if (Objects.isNull(response) || !response.has("access_token")) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
        }
        return response.get("access_token").asText();
    }

    @Generated
    public IntegracaoBoletoBBService(RestTemplate restTemplate, ParametroGeralService parametroGeralService, ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager) {
        this.restTemplate = restTemplate;
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
    }
}

