/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.time.LocalDate;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeraCertidaoDividaAtivaService {
    private final CadastroGeralService cadastroGeralService;
    private final EntityManager entityManager;

    GeraCertidaoDividaAtivaService(CadastroGeralService cadastroGeralService, EntityManager entityManager) {
        this.cadastroGeralService = cadastroGeralService;
        this.entityManager = entityManager;
    }

    public Documento gerarCertidaoDividaAtiva(LoteCdaItem loteCdaItem, Long entidade, Long exercicio, DocumentoTipo documentoTipo, EntidadeTributacao entidadeTributacao, LocalDate dataEmissao) {
        Documento documento = new Documento();
        documento.setEntidade(entidade);
        documento.setTipoDocumento(documentoTipo.getId());
        documento.setExercicio(exercicio);
        documento.setDocumentoTipo(documentoTipo);
        documento.setDataEmissao(dataEmissao);
        documento.setEntidadeTributacao(entidadeTributacao);
        documento.setTipoCadastro(loteCdaItem.getCadastroGeral().getTipoCadastro());
        documento.setCadastroGeral(loteCdaItem.getCadastroGeral());
        documento.setPessoa(this.cadastroGeralService.getResponsavelPrincipal(loteCdaItem.getCadastroGeral()));
        documento.setCnpjCpf(documento.getPessoa().getCnpjCpf());
        documento.setSituacao(SituacaoDocumento.aberto());
        documento.setUsuario(SecurityUtils.getUserAise());
        for (LoteCdaItemDetalhe item : loteCdaItem.getItemDetalhes()) {
            DocumentoItemDividaAtiva itemDividaAtiva = new DocumentoItemDividaAtiva();
            DebitoParcela debitoParcela = item.getParcelaTributo().getDebitoParcela();
            itemDividaAtiva.setLivro((Livro)this.entityManager.getReference(Livro.class, (Object)LivroId.of((Long)entidade, (Long)debitoParcela.getExercicioLivro(), (Long)debitoParcela.getLivro())));
            itemDividaAtiva.setNumeroInscricao(debitoParcela.getNumeroInscricao());
            itemDividaAtiva.setNumeroFolha(debitoParcela.getNumeroFolha());
            itemDividaAtiva.setTipoCadastro(item.getParcelaTributo().getTipoCadastro());
            itemDividaAtiva.setCadastroGeral(item.getParcelaTributo().getCadastroGeral());
            itemDividaAtiva.setExercicioDebito(item.getParcelaTributo().getExercicio());
            itemDividaAtiva.setTributo(item.getParcelaTributo().getTributo());
            itemDividaAtiva.setDivida(debitoParcela.getDebito().getDivida());
            itemDividaAtiva.setCodigoDivida(debitoParcela.getDebito().getDivida().getDivida());
            itemDividaAtiva.setSubDivida(item.getParcelaTributo().getSubDivida());
            itemDividaAtiva.setParcela(item.getParcelaTributo().getParcela());
            itemDividaAtiva.setValor(item.getValor());
            itemDividaAtiva.setValorMulta(item.getValorMulta());
            itemDividaAtiva.setValorJuros(item.getValorJuros());
            itemDividaAtiva.setValorCorrecao(item.getValorCorrecao());
            documento.getDocumentoItemDividaAtivas().add(itemDividaAtiva);
        }
        loteCdaItem.getItemPessoas().stream().map(LoteCdaItemPessoa::getPessoa).map(pessoa -> DocumentoPessoa.of((Pessoa)pessoa, (Documento)documento)).forEach(documento.getDocumentoPessoas()::add);
        return documento;
    }
}

