/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.correcao;

import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecao;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public class CalculoCorrecaoVariacao
implements CalculoCorrecao {
    public BigDecimal calculoValorCorrecao(BigDecimal valorTributo, LocalDate dataBaseCalculo, LocalDate dataReferencia, IndiceComposto indiceComposto, ValorIndice valorIndiceCorrecao, List<MudancaMonetaria> correcoesMonetarias) {
        ValorIndice valorUltimoIndiceCorrecao = CalculoCorrecaoUtils.getUltimoValorIndice((IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo, (LocalDate)dataReferencia);
        BigDecimal indice = valorIndiceCorrecao.getValor();
        if (Objects.nonNull(correcoesMonetarias) && !correcoesMonetarias.isEmpty()) {
            for (MudancaMonetaria correcao : correcoesMonetarias) {
                if (!correcao.getData().isAfter(valorIndiceCorrecao.getData()) || correcao.getData().isAfter(valorUltimoIndiceCorrecao.getData())) continue;
                indice = indice.divide(correcao.getValorMonetario(), (int)CalculoValoresConstants.DEZESSEIS_CASAS_DECIMAIS, 3);
            }
        }
        return valorUltimoIndiceCorrecao.getValor().divide(indice, (int)CalculoValoresConstants.DEZESSEIS_CASAS_DECIMAIS, 3).multiply(valorTributo).subtract(valorTributo).setScale((int)CalculoValoresConstants.DEZESSEIS_CASAS_DECIMAIS, 3);
    }
}

