/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcelaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntradaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoUsuario;
import br.com.elotech.tributos.dto.ParamParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroDebitoAbertoDTO;
import br.com.elotech.tributos.params.FiltroDebitoParams;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoUsuarioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ParamParcelamentoService
extends CrudService<ParamParcelamento, Long> {
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final ParamParcelamentoUsuarioRepository paramParcelamentoUsuarioRepository;

    public ParamParcelamentoService(ParamParcelamentoRepository paramParcelamentoRepository, ParamParcelamentoUsuarioRepository paramParcelamentoUsuarioRepository) {
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.paramParcelamentoUsuarioRepository = paramParcelamentoUsuarioRepository;
    }

    public List<FiltroDebitoAbertoDTO> testeScriptFiltroDebito(FiltroDebitoParams params) {
        return this.paramParcelamentoRepository.testeScriptFiltroDebito(params);
    }

    public Page<ParamParcelamento> findParametrosByPermissaoUsuario(Pageable pageable) {
        String usuarioAise = SecurityUtils.getUserAise();
        List resultado = this.paramParcelamentoUsuarioRepository.findByIdUsuario(usuarioAise).stream().map(ParamParcelamentoUsuario::getParametroParcelamento).sorted(Comparator.comparing(ParamParcelamento::getId)).collect(Collectors.toList());
        return new PageImpl(resultado, pageable, (long)resultado.size());
    }

    protected void beforeSave(ParamParcelamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.getEntradas().forEach(entrada -> {
            if (entrada.getId() == null) {
                ParamParcelamentoEntradaId id = new ParamParcelamentoEntradaId();
                entrada.setId(id);
            }
            entrada.getId().setParametroParcelamento(entity);
            if (entrada.getId().getEntrada() == null) {
                entrada.getId().setEntrada(entity.getNumeroProximaEntrada());
            }
            entrada.getJuros().forEach(juros -> juros.setEntrada(entrada));
        });
        entity.getParcelasSituacao().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
        entity.getParcelasPorValor().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
        entity.getDescontosPorParcela().forEach(desconto -> {
            if (desconto.getId() == null) {
                ParamParcelamentoDescontoParcelaId id = new ParamParcelamentoDescontoParcelaId();
                desconto.setId(id);
            }
            desconto.getId().setParametroParcelamento(entity);
            if (desconto.getId().getSequencia() == null) {
                desconto.getId().setSequencia(entity.getSequenciaProximoDescontoPorParcela());
            }
        });
        entity.getDescontosPorDivida().forEach(desconto -> {
            desconto.setParametroParcelamento(entity);
            desconto.getReceitas().forEach(tributo -> tributo.setParametroParcelamentoDescontoGuia(desconto));
        });
    }

    public List<ParamParcelamento> findByDisponivelCidadao() {
        return this.paramParcelamentoRepository.findByDisponivelCidadaoTrue();
    }

    public ParamParcelamentoDTO salvarParametroParcelamentoCidadao(ParamParcelamentoDTO paramParcelamentoDTO) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)paramParcelamentoDTO.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel carregar o Par\u00e2metro Parcelamento com id %d", paramParcelamentoDTO.getId())));
        paramParcelamento.setDescricao(paramParcelamentoDTO.getDescricao());
        paramParcelamento.setDisponivelCidadao(paramParcelamentoDTO.getDisponivelCidadao());
        paramParcelamento.setTermoConfissaoDivida(paramParcelamentoDTO.getTermoConfissaoDivida());
        paramParcelamento.setAtivo(paramParcelamentoDTO.getAtivo());
        return ((ParamParcelamento)this.paramParcelamentoRepository.save((Object)paramParcelamento)).toDto();
    }
}

