/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.PessoaService;
import java.io.Serializable;
import org.springframework.stereotype.Service;

@Service
public class DocumentoPessoaService
extends CrudService<DocumentoPessoa, Long> {
    private final DocumentoService documentoService;
    private final PessoaService pessoaService;

    public DocumentoPessoaService(DocumentoService documentoService, PessoaService pessoaService) {
        this.documentoService = documentoService;
        this.pessoaService = pessoaService;
    }

    public Documento removePessoa(Long idDocumento, Long idDocumentoPessoa) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idDocumento);
        if (documento.getDocumentoPessoas().size() <= 1) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover o \u00fanico propriet\u00e1rio da CDA.");
        }
        documento.getDocumentoPessoas().removeIf(documentoPessoa -> documentoPessoa.getId().equals(idDocumentoPessoa));
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }

    public Documento adicionarPessoaAoDocumento(Long idDocumento, Long idPessoa) {
        Pessoa pessoa = this.pessoaService.findOne(idPessoa);
        if (!pessoa.isValidCnpjCpf().booleanValue()) {
            throw new EloValidationException("Contribuinte com CPF/CNPJ inv\u00e1lido, realize a corre\u00e7\u00e3o antes de continuar.");
        }
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idDocumento);
        boolean existeDocumentoPessoa = documento.getDocumentoPessoas().stream().anyMatch(documentoPessoa -> idPessoa.equals(documentoPessoa.getPessoa().getId()));
        if (existeDocumentoPessoa) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel adicionar novamente um propriet\u00e1rio existente na CDA.");
        }
        DocumentoPessoa documentoPessoa2 = new DocumentoPessoa();
        documentoPessoa2.setDocumento(documento);
        documentoPessoa2.setPessoa(pessoa);
        documento.getDocumentoPessoas().add(documentoPessoa2);
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }
}

