/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroGeomaisDTO;
import br.com.elotech.tributos.service.LogradouroService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/logradouro"})
public class LogradouroGeomaisResource {
    public final LogradouroService logradouroService;

    public LogradouroGeomaisResource(LogradouroService logradouroService) {
        this.logradouroService = logradouroService;
    }

    @GetMapping
    public ResponseEntity<Page<LogradouroGeomaisDTO>> findAllByCidadeEntidadePrincipal(Pageable page) {
        Page logradouros = this.logradouroService.findAllByCidadeEntidadePrincipal(page).map(LogradouroGeomaisDTO::from);
        return ResponseEntity.ok((Object)logradouros);
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<LogradouroGeomaisDTO> findByLogradouroAndCidadeEntidadePrincipal(@PathVariable Long codigo) {
        LogradouroGeomaisDTO logradouroDTO = this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(codigo).map(LogradouroGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Logradouro com o c\u00f3digo '%d'.", codigo)));
        return ResponseEntity.ok((Object)logradouroDTO);
    }
}

