/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostGeomaisDTO;
import br.com.elotech.tributos.service.integracaogeomais.CadastroImobiliarioElogeoService;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro"})
public class CadastroGeralGeomaisResource {
    private final CadastroImobiliarioElogeoService cadastroImobiliarioElogeoService;

    public CadastroGeralGeomaisResource(CadastroImobiliarioElogeoService cadastroImobiliarioElogeoService) {
        this.cadastroImobiliarioElogeoService = cadastroImobiliarioElogeoService;
    }

    @GetMapping
    public ResponseEntity<Page<CadastroGeralGeomaisDTO>> findAllDTO(Pageable page) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.findAllGeomaisDTO(page));
    }

    @GetMapping(value={"/imobiliario/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralGeomaisDTO> findByCadastroGeralGeomaisDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.findByCadastroGeralGeomaisDTO(cadastroGeral));
    }

    @PutMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralGeomaisDTO> update(@PathVariable Long cadastroGeral, @RequestBody @Valid CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeoService.saveGeomaisDTO(cadastroGeralPostGeomaisDTO, Boolean.FALSE, cadastroGeral));
    }

    @PostMapping
    public ResponseEntity<CadastroGeralGeomaisDTO> save(@RequestBody @Valid CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.cadastroImobiliarioElogeoService.saveGeomaisDTO(cadastroGeralPostGeomaisDTO, Boolean.TRUE, null));
    }
}

