/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoId;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidade-correcao"})
public class EntidadeCorrecaoResource
extends CrudResource<EntidadeCorrecao, EntidadeCorrecaoId> {
    private final EntidadeCorrecaoService entidadeCorrecaoService;

    public EntidadeCorrecaoResource(EntidadeCorrecaoService entidadeCorrecaoService) {
        this.entidadeCorrecaoService = entidadeCorrecaoService;
    }

    @GetMapping(value={"/pk/{idEntidade}/{exercicio}/{sequencia}"})
    public ResponseEntity<EntidadeCorrecao> getEntidadeCorrecaoById(@PathVariable Long idEntidade, @PathVariable Long exercicio, @PathVariable Long sequencia) {
        return ResponseEntity.ok((Object)((EntidadeCorrecao)this.entidadeCorrecaoService.findOne((Serializable)EntidadeCorrecaoId.of((Long)idEntidade, (Long)exercicio, (Long)sequencia))));
    }

    @PutMapping(value={"/pk/{idEntidade}/{exercicio}/{sequencia}"})
    public ResponseEntity<EntidadeCorrecao> update(@PathVariable Long idEntidade, @PathVariable Long exercicio, @PathVariable Long sequencia, @RequestBody @Valid EntidadeCorrecao entity, @AuthenticationPrincipal Authentication authentication) {
        EntidadeCorrecaoId id = EntidadeCorrecaoId.of((Long)idEntidade, (Long)exercicio, (Long)sequencia);
        if (!this.entidadeCorrecaoService.getCrudRepository().existsById((Object)id)) {
            throw RestException.notFound();
        }
        this.beforeUpdate((EloEntity)entity);
        return ResponseEntity.ok((Object)((EntidadeCorrecao)this.entidadeCorrecaoService.save((EloEntity)entity, authentication)));
    }

    @DeleteMapping(value={"/pk/{idEntidade}/{exercicio}/{sequencia}"})
    public ResponseEntity<Void> deleteEntidadeCorrecao(@PathVariable Long idEntidade, @PathVariable Long exercicio, @PathVariable Long sequencia) {
        this.entidadeCorrecaoService.deleteEntidadeCorrecao(idEntidade, exercicio, sequencia);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/principal/{idEntidade}/{exercicio}/{sequencia}"})
    public ResponseEntity<Void> setPrincipal(@PathVariable Long idEntidade, @PathVariable Long exercicio, @PathVariable Long sequencia) {
        this.entidadeCorrecaoService.setPrincipal(idEntidade, exercicio, sequencia);
        return ResponseEntity.noContent().build();
    }
}

