/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.pagamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CreditoContribuinte;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Entity
@Table(name="TRIBBAIXAAUTOMATICADETALHE")
@DynamicUpdate
public class BaixaAutomaticaDetalhe
implements EloEntity<BaixaAutomaticaDetalheId> {
    @EmbeddedId
    private BaixaAutomaticaDetalheId id;
    private ClassificacaoTipoMensagem situacao;
    private String nossoNumero;
    private String nossoNumeroAntigo;
    private LocalDate dataVencimento;
    private LocalDate dataPagamento;
    private Long anoMovimento;
    private Long mesMovimento;
    @OneToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioPagamento", referencedColumnName="exercicioPagamento")), @JoinColumnOrFormula(column=@JoinColumn(name="pagamento", referencedColumnName="pagamento"))})
    private Pagamento pagamento;
    @OneToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exerciciobloqueto", referencedColumnName="exerciciobloqueto")), @JoinColumnOrFormula(column=@JoinColumn(name="bloqueto", referencedColumnName="bloqueto"))})
    private Bloqueto boleto;
    @OneToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false, insertable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false, insertable=false), @JoinColumn(name="creditocontribuinte", referencedColumnName="creditocontribuinte", updatable=false, insertable=false)})
    private CreditoContribuinte creditoContribuinte;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorPago = BigDecimal.ZERO;
    @MapsId(value="entidade, exercicio, lote")
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="lote", referencedColumnName="lote", updatable=false)})
    private PagamentoLote pagamentoLote;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoMensagem", referencedColumnName="tipoMensagem")
    private TipoMensagem tipoMensagem;
    private String mensagem;
    private String detalhe;
    private String usuarioAlteracao;
    private LocalDate dataAlteracao;
    private Boolean alterado = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDeducao;
    private LocalDate dataDesconto;
    private String usuarioDesconto;
    private Boolean descontoConcedido = Boolean.FALSE;
    private Boolean autorizadoPagoAMenor = Boolean.FALSE;
    private LocalDate dataAutorizacaoPagoAMenor;
    private String usuarioAutorizacaoPagoAMenor;
    private LocalDate dataCredito;
    @Column(name="tipooperacaodebito")
    private TipoOperacaoDebito tipoOperacao;
    private Long idDebitoOperacao;
    private Long parcelaOperacao;
    private BigDecimal valorPagoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorPagoJuros = BigDecimal.ZERO;
    private BigDecimal valorPagoMulta = BigDecimal.ZERO;

    public void setMensagemPagoAMenor(BigDecimal diferenca) {
        this.mensagem = String.format(TipoMensagemEnum.BOLETO_PAGO_A_MENOR.getDescricao(), diferenca);
    }

    public void setMensagemPagoAMaior(BigDecimal diferenca) {
        this.mensagem = String.format(TipoMensagemEnum.BOLETO_VALIDADO_PAGO_A_MAIOR.getDescricao(), diferenca);
    }

    public void setMensagemPagoComSucesso(Bloqueto boleto, Pagamento pagamento) {
        this.mensagem = String.format(TipoMensagemEnum.PAGO_COM_SUCESSO.getDescricao(), boleto.getBloqueto(), boleto.getExercicioBloqueto(), pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento());
    }

    public void setMensagemPagoComDesconto(Bloqueto boleto, Pagamento pagamento) {
        this.mensagem = String.format(TipoMensagemEnum.PAGO_COM_DESCONTO_CONCEDIDO.getDescricao(), boleto.getBloqueto(), boleto.getExercicioBloqueto(), pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento());
    }

    public void setMensagemPagoAMenor(Bloqueto boleto, Pagamento pagamento) {
        this.mensagem = String.format("Boleto %d/%d Pago a Menor. Pagamento %d/%d", boleto.getBloqueto(), boleto.getExercicioBloqueto(), pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento());
    }

    public BigDecimal getValorDesconto() {
        return this.valor.subtract(this.valorPago);
    }

    public BigDecimal getValorPagoAMaior() {
        return this.valorPago.subtract(this.valor);
    }

    public void verificaSituacaoSequenciaBaixa() {
        if (!this.getSituacao().permiteBaixa().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel realizar a Baixa nesse status.");
        }
    }

    public void verificaSituacaoSequenciaVerificacao() {
        if (!this.getSituacao().permiteVerificacao().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel realizar a Verifica\u00e7\u00e3o nesse status.");
        }
    }

    @Generated
    public BaixaAutomaticaDetalhe() {
    }

    @Generated
    public BaixaAutomaticaDetalheId getId() {
        return this.id;
    }

    @Generated
    public ClassificacaoTipoMensagem getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getNossoNumeroAntigo() {
        return this.nossoNumeroAntigo;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public Long getAnoMovimento() {
        return this.anoMovimento;
    }

    @Generated
    public Long getMesMovimento() {
        return this.mesMovimento;
    }

    @Generated
    public Pagamento getPagamento() {
        return this.pagamento;
    }

    @Generated
    public Bloqueto getBoleto() {
        return this.boleto;
    }

    @Generated
    public CreditoContribuinte getCreditoContribuinte() {
        return this.creditoContribuinte;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public PagamentoLote getPagamentoLote() {
        return this.pagamentoLote;
    }

    @Generated
    public TipoMensagem getTipoMensagem() {
        return this.tipoMensagem;
    }

    @Generated
    public String getMensagem() {
        return this.mensagem;
    }

    @Generated
    public String getDetalhe() {
        return this.detalhe;
    }

    @Generated
    public String getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Boolean getAlterado() {
        return this.alterado;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public LocalDate getDataDesconto() {
        return this.dataDesconto;
    }

    @Generated
    public String getUsuarioDesconto() {
        return this.usuarioDesconto;
    }

    @Generated
    public Boolean getDescontoConcedido() {
        return this.descontoConcedido;
    }

    @Generated
    public Boolean getAutorizadoPagoAMenor() {
        return this.autorizadoPagoAMenor;
    }

    @Generated
    public LocalDate getDataAutorizacaoPagoAMenor() {
        return this.dataAutorizacaoPagoAMenor;
    }

    @Generated
    public String getUsuarioAutorizacaoPagoAMenor() {
        return this.usuarioAutorizacaoPagoAMenor;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public TipoOperacaoDebito getTipoOperacao() {
        return this.tipoOperacao;
    }

    @Generated
    public Long getIdDebitoOperacao() {
        return this.idDebitoOperacao;
    }

    @Generated
    public Long getParcelaOperacao() {
        return this.parcelaOperacao;
    }

    @Generated
    public BigDecimal getValorPagoPrincipal() {
        return this.valorPagoPrincipal;
    }

    @Generated
    public BigDecimal getValorPagoJuros() {
        return this.valorPagoJuros;
    }

    @Generated
    public BigDecimal getValorPagoMulta() {
        return this.valorPagoMulta;
    }

    @Generated
    public void setId(BaixaAutomaticaDetalheId id) {
        this.id = id;
    }

    @Generated
    public void setSituacao(ClassificacaoTipoMensagem situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setNossoNumeroAntigo(String nossoNumeroAntigo) {
        this.nossoNumeroAntigo = nossoNumeroAntigo;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setAnoMovimento(Long anoMovimento) {
        this.anoMovimento = anoMovimento;
    }

    @Generated
    public void setMesMovimento(Long mesMovimento) {
        this.mesMovimento = mesMovimento;
    }

    @Generated
    public void setPagamento(Pagamento pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setBoleto(Bloqueto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setCreditoContribuinte(CreditoContribuinte creditoContribuinte) {
        this.creditoContribuinte = creditoContribuinte;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setPagamentoLote(PagamentoLote pagamentoLote) {
        this.pagamentoLote = pagamentoLote;
    }

    @Generated
    public void setTipoMensagem(TipoMensagem tipoMensagem) {
        this.tipoMensagem = tipoMensagem;
    }

    @Generated
    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public void setDetalhe(String detalhe) {
        this.detalhe = detalhe;
    }

    @Generated
    public void setUsuarioAlteracao(String usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setAlterado(Boolean alterado) {
        this.alterado = alterado;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setDataDesconto(LocalDate dataDesconto) {
        this.dataDesconto = dataDesconto;
    }

    @Generated
    public void setUsuarioDesconto(String usuarioDesconto) {
        this.usuarioDesconto = usuarioDesconto;
    }

    @Generated
    public void setDescontoConcedido(Boolean descontoConcedido) {
        this.descontoConcedido = descontoConcedido;
    }

    @Generated
    public void setAutorizadoPagoAMenor(Boolean autorizadoPagoAMenor) {
        this.autorizadoPagoAMenor = autorizadoPagoAMenor;
    }

    @Generated
    public void setDataAutorizacaoPagoAMenor(LocalDate dataAutorizacaoPagoAMenor) {
        this.dataAutorizacaoPagoAMenor = dataAutorizacaoPagoAMenor;
    }

    @Generated
    public void setUsuarioAutorizacaoPagoAMenor(String usuarioAutorizacaoPagoAMenor) {
        this.usuarioAutorizacaoPagoAMenor = usuarioAutorizacaoPagoAMenor;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setTipoOperacao(TipoOperacaoDebito tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    @Generated
    public void setIdDebitoOperacao(Long idDebitoOperacao) {
        this.idDebitoOperacao = idDebitoOperacao;
    }

    @Generated
    public void setParcelaOperacao(Long parcelaOperacao) {
        this.parcelaOperacao = parcelaOperacao;
    }

    @Generated
    public void setValorPagoPrincipal(BigDecimal valorPagoPrincipal) {
        this.valorPagoPrincipal = valorPagoPrincipal;
    }

    @Generated
    public void setValorPagoJuros(BigDecimal valorPagoJuros) {
        this.valorPagoJuros = valorPagoJuros;
    }

    @Generated
    public void setValorPagoMulta(BigDecimal valorPagoMulta) {
        this.valorPagoMulta = valorPagoMulta;
    }

    @Generated
    public String toString() {
        return "BaixaAutomaticaDetalhe(id=" + this.getId() + ", situacao=" + this.getSituacao() + ", nossoNumero=" + this.getNossoNumero() + ", nossoNumeroAntigo=" + this.getNossoNumeroAntigo() + ", dataVencimento=" + this.getDataVencimento() + ", dataPagamento=" + this.getDataPagamento() + ", anoMovimento=" + this.getAnoMovimento() + ", mesMovimento=" + this.getMesMovimento() + ", pagamento=" + this.getPagamento() + ", boleto=" + this.getBoleto() + ", creditoContribuinte=" + this.getCreditoContribuinte() + ", valor=" + this.getValor() + ", valorPago=" + this.getValorPago() + ", pagamentoLote=" + this.getPagamentoLote() + ", tipoMensagem=" + this.getTipoMensagem() + ", mensagem=" + this.getMensagem() + ", detalhe=" + this.getDetalhe() + ", usuarioAlteracao=" + this.getUsuarioAlteracao() + ", dataAlteracao=" + this.getDataAlteracao() + ", alterado=" + this.getAlterado() + ", motivoDeducao=" + this.getMotivoDeducao() + ", dataDesconto=" + this.getDataDesconto() + ", usuarioDesconto=" + this.getUsuarioDesconto() + ", descontoConcedido=" + this.getDescontoConcedido() + ", autorizadoPagoAMenor=" + this.getAutorizadoPagoAMenor() + ", dataAutorizacaoPagoAMenor=" + this.getDataAutorizacaoPagoAMenor() + ", usuarioAutorizacaoPagoAMenor=" + this.getUsuarioAutorizacaoPagoAMenor() + ", dataCredito=" + this.getDataCredito() + ", tipoOperacao=" + this.getTipoOperacao() + ", idDebitoOperacao=" + this.getIdDebitoOperacao() + ", parcelaOperacao=" + this.getParcelaOperacao() + ", valorPagoPrincipal=" + this.getValorPagoPrincipal() + ", valorPagoJuros=" + this.getValorPagoJuros() + ", valorPagoMulta=" + this.getValorPagoMulta() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaixaAutomaticaDetalhe)) {
            return false;
        }
        BaixaAutomaticaDetalhe other = (BaixaAutomaticaDetalhe)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BaixaAutomaticaDetalheId this$id = this.getId();
        BaixaAutomaticaDetalheId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaixaAutomaticaDetalhe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaixaAutomaticaDetalheId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

