/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.documento.peticao;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItemDetalhe;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="triblotepeticaoitem")
public class LotePeticaoItem
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="SLOTEPETICAOITEM")
    private Long id;
    private Long sequencia;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idlotepeticao", nullable=false)
    @JsonIgnore
    @MetaModelIgnore
    private LotePeticao lote;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="iddocumentogerado", nullable=false)
    @JsonIgnoreProperties(value={"entidadeTributacao"})
    private Documento documento;
    @OneToMany(mappedBy="item", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<LotePeticaoItemDetalhe> detalhes = new ArrayList();

    @JsonIgnore
    public void setChildrenId() {
        this.detalhes.forEach(lotePeticaoItemDetalhe -> lotePeticaoItemDetalhe.setItem(this));
    }

    public BigDecimal getValorTotal() {
        return this.detalhes.stream().map(LotePeticaoItemDetalhe::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Pessoa getPessoa() {
        if (Objects.isNull(this.detalhes) || this.detalhes.isEmpty()) {
            return null;
        }
        return ((LotePeticaoItemDetalhe)this.detalhes.get(0)).getDocumento().getPessoa();
    }

    @JsonIgnore
    public Boolean hasPeticoesCadastrosDiferentes() {
        return this.getDetalhes().stream().map(LotePeticaoItemDetalhe::getDocumento).map(Documento::getCadastroGeral).distinct().count() > 1L;
    }

    @Generated
    public LotePeticaoItem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public LotePeticao getLote() {
        return this.lote;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public List<LotePeticaoItemDetalhe> getDetalhes() {
        return this.detalhes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setLote(LotePeticao lote) {
        this.lote = lote;
    }

    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @Generated
    public void setDetalhes(List<LotePeticaoItemDetalhe> detalhes) {
        this.detalhes = detalhes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LotePeticaoItem)) {
            return false;
        }
        LotePeticaoItem other = (LotePeticaoItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LotePeticaoItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LotePeticaoItem(id=" + this.getId() + ")";
    }
}

