/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTexto;
import br.com.elotech.tributos.domain.DocumentoTipoAssinatura;
import br.com.elotech.tributos.domain.DocumentoTipoOutros;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoValidadeDocumento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.DocumentoTipoAssinaturaDTO;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBDOCUMENTOTIPO")
public class DocumentoTipo
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="tipodocumento")
    private Long id;
    @Length(max=50)
    private @Length(max=50) String descricao;
    private Boolean impressaoWeb;
    private Boolean porCadastroGeral;
    private Boolean inativo = Boolean.FALSE;
    private Boolean exigeProcesso;
    @Column(name="cabecalho")
    private Boolean possuiCabecalho;
    @Column(name="rodape")
    private Boolean possuiRodape;
    @Column(name="observacao")
    private Boolean possuiObservacao;
    @Column(name="historico")
    private Boolean possuiHistorico;
    @Column(name="salvapdf")
    private Boolean armazenarComoPdf;
    @Column(name="maisdeumlayout")
    private Boolean maisDeUmLayout;
    private Boolean verificaDebitoPendente;
    @Column(name="verificaassinatura")
    private Boolean verificaAssinaturaDigital;
    private Boolean exigeProjeto;
    @Column(name="assuntoprotocolo")
    private Long assunto;
    @ElementCollection
    @CollectionTable(name="TRIBDOCUMENTOTIPOCADASTRO", joinColumns={@JoinColumn(name="tipodocumento")})
    @Column(name="tipocadastro")
    private List<TipoCadastro> tiposCadastro;
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento"})
    private List<DocumentoTipoAssinatura> assinaturas = new ArrayList();
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento"})
    private List<DocumentoTexto> textos = new ArrayList();
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento"})
    private List<DocumentoTipoOutros> outros = new ArrayList();
    @ManyToMany
    @JoinTable(name="TRIBDOCUMENTOTIPORELATORIO", joinColumns={@JoinColumn(name="tipodocumento")}, inverseJoinColumns={@JoinColumn(name="relatorio", referencedColumnName="relatorio"), @JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio")})
    private List<Relatorio> relatorios = new ArrayList();
    private Boolean geraDocumentoCentral;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio"), @JoinColumn(name="relatorio", referencedColumnName="relatorio")})
    private Relatorio relatorio;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="tribdocumentogrupotipo", joinColumns={@JoinColumn(name="tipodocumento", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="grupodocumento")})
    private List<GrupoDocumento> gruposDocumento = new ArrayList();
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento", "entidadeTributacao"})
    private List<DocumentoFinalidade> finalidades = new ArrayList();
    private Integer validadeDia;
    private LocalDate validadeData;
    private TipoValidadeDocumento validade;

    @JsonIgnore
    public List<DocumentoFinalidade> getFinalidadesDoExercicio(Long exercicio) {
        return this.getFinalidades().stream().filter(finalidade -> exercicio.equals(finalidade.getExercicio())).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<DocumentoFinalidade> getFinalidadesForaDoExercicio(Long exercicio) {
        return this.getFinalidades().stream().filter(finalidade -> !exercicio.equals(finalidade.getExercicio())).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<DocumentoTipoAssinatura> mergeAssinaturas(List<DocumentoTipoAssinaturaDTO> assinaturasDTO) {
        List assinaturasFromDTO = assinaturasDTO.stream().map(assinaturaDTO -> DocumentoTipoAssinaturaDTO.toEntity((DocumentoTipoAssinaturaDTO)assinaturaDTO, (Long)this.getId())).collect(Collectors.toList());
        List assinaturasMerged = ListUtils.merge((List)this.getAssinaturas(), assinaturasFromDTO, DocumentoTipoAssinatura::getId, DocumentoTipoAssinatura::merge);
        AtomicLong lastSequencia = new AtomicLong(this.getLastSequenciaAssinatura(assinaturasMerged));
        assinaturasMerged.stream().filter(assinatura -> Objects.isNull(assinatura.getId().getSequencia())).forEach(assinatura -> assinatura.getId().setSequencia(Long.valueOf(lastSequencia.getAndIncrement())));
        return assinaturasMerged;
    }

    private Long getLastSequenciaAssinatura(List<DocumentoTipoAssinatura> assinaturas) {
        return assinaturas.stream().filter(assinatura -> Objects.nonNull(assinatura.getId()) && Objects.nonNull(assinatura.getId().getSequencia())).map(assinatura -> assinatura.getId().getSequencia()).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }

    @Generated
    public String toString() {
        return "DocumentoTipo(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoTipo)) {
            return false;
        }
        DocumentoTipo other = (DocumentoTipo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoTipo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public DocumentoTipo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getImpressaoWeb() {
        return this.impressaoWeb;
    }

    @Generated
    public Boolean getPorCadastroGeral() {
        return this.porCadastroGeral;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public Boolean getExigeProcesso() {
        return this.exigeProcesso;
    }

    @Generated
    public Boolean getPossuiCabecalho() {
        return this.possuiCabecalho;
    }

    @Generated
    public Boolean getPossuiRodape() {
        return this.possuiRodape;
    }

    @Generated
    public Boolean getPossuiObservacao() {
        return this.possuiObservacao;
    }

    @Generated
    public Boolean getPossuiHistorico() {
        return this.possuiHistorico;
    }

    @Generated
    public Boolean getArmazenarComoPdf() {
        return this.armazenarComoPdf;
    }

    @Generated
    public Boolean getMaisDeUmLayout() {
        return this.maisDeUmLayout;
    }

    @Generated
    public Boolean getVerificaDebitoPendente() {
        return this.verificaDebitoPendente;
    }

    @Generated
    public Boolean getVerificaAssinaturaDigital() {
        return this.verificaAssinaturaDigital;
    }

    @Generated
    public Boolean getExigeProjeto() {
        return this.exigeProjeto;
    }

    @Generated
    public Long getAssunto() {
        return this.assunto;
    }

    @Generated
    public List<TipoCadastro> getTiposCadastro() {
        return this.tiposCadastro;
    }

    @Generated
    public List<DocumentoTipoAssinatura> getAssinaturas() {
        return this.assinaturas;
    }

    @Generated
    public List<DocumentoTexto> getTextos() {
        return this.textos;
    }

    @Generated
    public List<DocumentoTipoOutros> getOutros() {
        return this.outros;
    }

    @Generated
    public List<Relatorio> getRelatorios() {
        return this.relatorios;
    }

    @Generated
    public Boolean getGeraDocumentoCentral() {
        return this.geraDocumentoCentral;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public List<GrupoDocumento> getGruposDocumento() {
        return this.gruposDocumento;
    }

    @Generated
    public List<DocumentoFinalidade> getFinalidades() {
        return this.finalidades;
    }

    @Generated
    public Integer getValidadeDia() {
        return this.validadeDia;
    }

    @Generated
    public LocalDate getValidadeData() {
        return this.validadeData;
    }

    @Generated
    public TipoValidadeDocumento getValidade() {
        return this.validade;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setImpressaoWeb(Boolean impressaoWeb) {
        this.impressaoWeb = impressaoWeb;
    }

    @Generated
    public void setPorCadastroGeral(Boolean porCadastroGeral) {
        this.porCadastroGeral = porCadastroGeral;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setExigeProcesso(Boolean exigeProcesso) {
        this.exigeProcesso = exigeProcesso;
    }

    @Generated
    public void setPossuiCabecalho(Boolean possuiCabecalho) {
        this.possuiCabecalho = possuiCabecalho;
    }

    @Generated
    public void setPossuiRodape(Boolean possuiRodape) {
        this.possuiRodape = possuiRodape;
    }

    @Generated
    public void setPossuiObservacao(Boolean possuiObservacao) {
        this.possuiObservacao = possuiObservacao;
    }

    @Generated
    public void setPossuiHistorico(Boolean possuiHistorico) {
        this.possuiHistorico = possuiHistorico;
    }

    @Generated
    public void setArmazenarComoPdf(Boolean armazenarComoPdf) {
        this.armazenarComoPdf = armazenarComoPdf;
    }

    @Generated
    public void setMaisDeUmLayout(Boolean maisDeUmLayout) {
        this.maisDeUmLayout = maisDeUmLayout;
    }

    @Generated
    public void setVerificaDebitoPendente(Boolean verificaDebitoPendente) {
        this.verificaDebitoPendente = verificaDebitoPendente;
    }

    @Generated
    public void setVerificaAssinaturaDigital(Boolean verificaAssinaturaDigital) {
        this.verificaAssinaturaDigital = verificaAssinaturaDigital;
    }

    @Generated
    public void setExigeProjeto(Boolean exigeProjeto) {
        this.exigeProjeto = exigeProjeto;
    }

    @Generated
    public void setAssunto(Long assunto) {
        this.assunto = assunto;
    }

    @Generated
    public void setTiposCadastro(List<TipoCadastro> tiposCadastro) {
        this.tiposCadastro = tiposCadastro;
    }

    @Generated
    public void setAssinaturas(List<DocumentoTipoAssinatura> assinaturas) {
        this.assinaturas = assinaturas;
    }

    @Generated
    public void setTextos(List<DocumentoTexto> textos) {
        this.textos = textos;
    }

    @Generated
    public void setOutros(List<DocumentoTipoOutros> outros) {
        this.outros = outros;
    }

    @Generated
    public void setRelatorios(List<Relatorio> relatorios) {
        this.relatorios = relatorios;
    }

    @Generated
    public void setGeraDocumentoCentral(Boolean geraDocumentoCentral) {
        this.geraDocumentoCentral = geraDocumentoCentral;
    }

    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setGruposDocumento(List<GrupoDocumento> gruposDocumento) {
        this.gruposDocumento = gruposDocumento;
    }

    @Generated
    public void setFinalidades(List<DocumentoFinalidade> finalidades) {
        this.finalidades = finalidades;
    }

    @Generated
    public void setValidadeDia(Integer validadeDia) {
        this.validadeDia = validadeDia;
    }

    @Generated
    public void setValidadeData(LocalDate validadeData) {
        this.validadeData = validadeData;
    }

    @Generated
    public void setValidade(TipoValidadeDocumento validade) {
        this.validade = validade;
    }
}

