/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DebitoTributoIsencao;
import br.com.elotech.tributos.domain.DebitoTributoIsencaoId;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribdebitoreceita")
public class DebitoTributo
implements EloEntity<DebitoTributoId>,
Serializable {
    @EmbeddedId
    private DebitoTributoId id;
    private Long ordem;
    @Column(name="valorreceita")
    private BigDecimal valorTributo = BigDecimal.ZERO;
    private BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorRenuncia = BigDecimal.ZERO;
    private Long tipoCalculoDebito;
    private Long calculo;
    private BigDecimal valorPrimeiraParcela;
    private String tipoConversao;
    private Boolean alterado;
    @EloSequence(sequenceName="S05IDDEBITORECEITA")
    private Long idDebitoReceita;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida")})
    private Debito debito;
    @OneToMany(mappedBy="tributo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoTributoIsencao> isencoes = new ArrayList();

    public static DebitoTributo of(DebitoManualTributoDTO tributoDTO) {
        DebitoTributo tributo = new DebitoTributo();
        DebitoTributoId id = new DebitoTributoId();
        id.setTributo(tributoDTO.getTributo());
        tributo.setId(id);
        tributo.setOrdem(tributoDTO.getOrdem());
        tributo.setValorRenuncia(tributoDTO.getValorRenuncia());
        tributo.setValorBaseCalculo(tributoDTO.getValorBaseCalculo());
        tributo.setValorTributo(tributoDTO.getValorTributo());
        return tributo;
    }

    public Boolean isZerado() {
        return BigDecimal.ZERO.equals(this.getValorTributo());
    }

    public BigDecimal getValorTotal() {
        return this.valorTributo.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao).subtract(Optional.ofNullable(this.valorDescontoPrincipal).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(this.valorDescontoJuros).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(this.valorDescontoMulta).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(this.valorDescontoCorrecao).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(this.valorRenuncia).orElse(BigDecimal.ZERO));
    }

    public void setIsencaoId() {
        this.getIsencoes().forEach(isencao -> {
            if (Objects.isNull(isencao.getId())) {
                isencao.setId(new DebitoTributoIsencaoId());
            }
            isencao.getId().setEntidade(this.getId().getEntidade());
            isencao.getId().setExercicio(this.getId().getExercicio());
            isencao.getId().setTipoCadastro(this.getId().getTipoCadastro());
            isencao.getId().setCadastroGeral(this.getId().getCadastroGeral());
            isencao.getId().setDivida(this.getId().getDivida());
            isencao.getId().setSubDivida(this.getId().getSubDivida());
            isencao.getId().setTributo(this.getId().getTributo());
            isencao.setTributo(this);
        });
    }

    @Generated
    public DebitoTributo() {
    }

    @Generated
    public DebitoTributoId getId() {
        return this.id;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public BigDecimal getValorTributo() {
        return this.valorTributo;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorRenuncia() {
        return this.valorRenuncia;
    }

    @Generated
    public Long getTipoCalculoDebito() {
        return this.tipoCalculoDebito;
    }

    @Generated
    public Long getCalculo() {
        return this.calculo;
    }

    @Generated
    public BigDecimal getValorPrimeiraParcela() {
        return this.valorPrimeiraParcela;
    }

    @Generated
    public String getTipoConversao() {
        return this.tipoConversao;
    }

    @Generated
    public Boolean getAlterado() {
        return this.alterado;
    }

    @Generated
    public Long getIdDebitoReceita() {
        return this.idDebitoReceita;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public List<DebitoTributoIsencao> getIsencoes() {
        return this.isencoes;
    }

    @Generated
    public void setId(DebitoTributoId id) {
        this.id = id;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setValorTributo(BigDecimal valorTributo) {
        this.valorTributo = valorTributo;
    }

    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorRenuncia(BigDecimal valorRenuncia) {
        this.valorRenuncia = valorRenuncia;
    }

    @Generated
    public void setTipoCalculoDebito(Long tipoCalculoDebito) {
        this.tipoCalculoDebito = tipoCalculoDebito;
    }

    @Generated
    public void setCalculo(Long calculo) {
        this.calculo = calculo;
    }

    @Generated
    public void setValorPrimeiraParcela(BigDecimal valorPrimeiraParcela) {
        this.valorPrimeiraParcela = valorPrimeiraParcela;
    }

    @Generated
    public void setTipoConversao(String tipoConversao) {
        this.tipoConversao = tipoConversao;
    }

    @Generated
    public void setAlterado(Boolean alterado) {
        this.alterado = alterado;
    }

    @Generated
    public void setIdDebitoReceita(Long idDebitoReceita) {
        this.idDebitoReceita = idDebitoReceita;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public void setIsencoes(List<DebitoTributoIsencao> isencoes) {
        this.isencoes = isencoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoTributo)) {
            return false;
        }
        DebitoTributo other = (DebitoTributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoTributoId this$id = this.getId();
        DebitoTributoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoTributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoTributoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoTributo(id=" + this.getId() + ")";
    }
}

