select item.id as iditemloteimpressao, cg.idkey, cg.tipocadastro, cg.cadastrogeral, gr.descricao as descricaodivida,
       gr.guiarecolhimento as divida, d.subdivida, d.numeroparcela,
       coalesce(ci.quadricula_inscricaocadastral, cicm.quadricula_inscricaocadastral) as quadricula,
       coalesce(ci.distrito_inscricaocadastral, cicm.distrito_inscricaocadastral) as distrito,
       coalesce(ci.setor_inscricaocadastral, cicm.setor_inscricaocadastral) as setor,
       coalesce(ci.quadra_inscricaocadastral, cicm.quadra_inscricaocadastral) as quadra,
       coalesce(ci.lote_inscricaocadastral, cicm.lote_inscricaocadastral) as lote,
       coalesce(ci.unidade_inscricaocadastral, cicm.unidade_inscricaocadastral) as unidade,
       (select coalesce(max(1),0)
                 from tribdebitoparcela p
                where p.tipocadastro   = ci.tipocadastro
                  and p.cadastrogeral  = ci.cadastrogeral
                  and situacaolegal    = 1
                  and p.situacaodebito = 1) constadebitodividaativa,
       cg.enderecocorrespondencia, cg.numerocorrespondencia, cg.complementocorrespondencia, cg.bairrocorrespondencia, cg.cidadeufcorrespondencia, cg.cepcorrespondencia, cg.ufcorrespondencia,
       pes.nome as nomepessoa, pes.cnpj_cpf as cpfcnpj, pes.tipopessoa, pes.pessoa as codigopessoa,
       ci.facequadra, tlog.descricao as tipologradourolocalizacao, lgr.descricao as logradourolocalizacao, cg.numero as numerolocalizacao,
       cg.complemento as complementolocalizacao, b.descricao as bairrolocalizacao, ci.quadra_descr as quadrafiscalizacao, ci.lote_descr as lotefiscalizacao, ci.complementolote, cg.cep as ceplocalizacao,
       case
         when cg.tipocadastro = 1
         then (select translate( obs.descricao, chr(10) || chr(13), ' ' )
                 from tribobservacao obs
                where obs.tipocadastro = ci.tipocadastro
                  and obs.cadastrogeral = ci.cadastrogeral
                  and obs.sequencia = ( select max( sequencia )
                                          from tribobservacao
                                         where tipocadastro = obs.tipocadastro
                                           and cadastrogeral = obs.cadastrogeral ))
         else ''
       end observacaocadastro,
       case
         when cg.tipocadastro = 1 AND CI.TIPOIMOVEL = 'P'
         then (select sum(areaconstruida)
                 from tribimobiliariosegmento
                where tipocadastro = ci.tipocadastro
                  and cadastrogeral = ci.cadastrogeral)
         else 0
       end areatotalconstruida,
       case
         when cg.tipocadastro = 1
         then case when :utilizatestadagenerica = 'S'
                   then (select sum(tit.tamanho)
                          from tribimobiliariotestadagenerica tit
                         where tit.tipocadastro = ci.tipocadastro
                           and tit.cadastrogeral = ci.cadastrogeral)
                   else (select sum(tit.tamanhotestada)
                          from tribimobiliariotestada tit
                         where tit.tipocadastro = ci.tipocadastro
                           and tit.cadastrogeral = ci.cadastrogeral)
             end
         else 0
       end somatestadas,
       case
         when cg.tipocadastro = 1
         then case when :utilizatestadagenerica = 'S'
                   then (select sum(tit.tamanho)
                          from tribimobiliariotestadagenerica tit
                         where tit.tipocadastro = ci.tipocadastro
                           and tit.cadastrogeral = ci.cadastrogeral
                           and tit.principal = 'S')
                   else (select sum(tit.tamanhotestada)
                          from tribimobiliariotestada tit
                         where tit.tipocadastro = ci.tipocadastro
                           and tit.cadastrogeral = ci.cadastrogeral
                           and tit.principal = 'S')
             end
         else 0
       end tamanhotestadaprincipal,
       ci.arealote, imv.valorvenalterritorial, imv.valorvenalpredial, tlo.loteamento, tlo.descricao as descricaoloteamento, ci.areatotalinscricao,
       pcor.pessoa as codigopessoacompromissario, pcor.nome as nomepessoacompromissario, pcor.cnpj_cpf as cpfcnpjcompromissario, pcor.tipopessoa as tipopessoacompromissario,
       (select sum(tdr.valorreceita) valordebito
          from tribdebitoreceita tdr
         where tdr.entidade         = d.entidade
           and tdr.exercicio        = d.exercicio
           and tdr.tipocadastro     = d.tipocadastro
           and tdr.cadastrogeral    = d.cadastrogeral
           and tdr.guiarecolhimento = d.guiarecolhimento
           and tdr.subdivida        = d.subdivida
       ) as valortotaldebito,
       cc.aliquota as aliquota,
       (%s) tributosCarne
       %s
  from calculoloteimpressaoitem item
  join calculocadastro cc                   on cc.id = item.idcalculocadastro
  join tribcadastrogeral cg                 on cg.idkey = cc.cadastro
  join tribguiarecolhimento gr              on gr.idkey = cc.iddivida
  join tribdebito d                         on d.iddebito = cc.iddebito
  join pessoa pes                           on pes.pessoa = cg.pessoa
  left join tribcadastroimobiliario ci      on ci.tribcadastrogeral_idkey = cg.idkey
  left join tribcadastromobiliario cm       on cm.tribcadastrogeral_idkey = cg.idkey
  left join tribcadastroimobiliario cicm    on cicm.tipocadastro = cm.tipocadastroimobiliario
                                           and cicm.cadastrogeral = cm.cadastrogeralimobiliario
  left join logradouro lgr                  on cg.logradouro = lgr.logradouro
                                           and cg.cidade = lgr.cidade
  left join tipologradouro tlog             on lgr.tipologradouro = tlog.tipologradouro
  left join bairro b                        on cg.bairro = b.bairro
                                           and cg.cidade = b.cidade
  left join cidade cid                      on cid.cidade = b.cidade
  left join tribproprietario cor            on cor.tipocadastro = cg.tipocadastro
                                           and cor.cadastrogeral = cg.cadastrogeral
                                           and cor.coresponsavelprincipal = 'S'
  left join pessoa pcor                     on pcor.pessoa = cor.pessoa
  left join tribloteamento tlo              on tlo.distrito = ci.distrito_inscricaocadastral
                                           and tlo.setor = ci.setor_inscricaocadastral
                                           and tlo.loteamento = ci.loteamento
  left join ( select tia.tipocadastro, tia.cadastrogeral, tia.valorvenalterritorial, tia.valorvenalpredial
                from tribimobiliarioavaliacao tia
               where tia.sequencia = ( select max( sequencia )
                                         from tribimobiliarioavaliacao
                                        where tipocadastro = tia.tipocadastro
                                          and cadastrogeral = tia.cadastrogeral )) imv on ci.tipocadastro = imv.tipocadastro
                                                                                      and ci.cadastrogeral = imv.cadastrogeral
where item.idcalculoloteimpressao = :idcalculoloteimpressao
order by item.ordem