/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.mobile;

import br.com.elotech.tributos.dto.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.repository.mobile.DebitoMobileRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoMobileService {
    private final DebitoMobileRepository debitoMobileRepository;

    public DebitoMobileService(DebitoMobileRepository debitoMobileRepository) {
        this.debitoMobileRepository = debitoMobileRepository;
    }

    public List<DebitoDTO> getDebitoBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitos) {
        ArrayList<DebitoDTO> listDebito = new ArrayList<DebitoDTO>();
        debitos.forEach(debito -> {
            if (debito.idParcelamentoNaoNuloEMaiorQueZero()) {
                listDebito.addAll(this.getDebitoBloquetoPorIdParcelamento(debito));
            } else {
                listDebito.addAll(this.getDebitoBloquetoPorIdDebito(debito));
            }
        });
        return listDebito;
    }

    public List<DebitoDTO> getDebitoBloquetoPorIdDebito(DebitoBloquetoMobileDTO debitoBloquetoMobileDTO) {
        DebitoDTO debito = this.debitoMobileRepository.findDebitoPorId(debitoBloquetoMobileDTO.getIdDebito());
        return this.generateDebitoBloqueto(debito, debitoBloquetoMobileDTO.getParcelas());
    }

    public List<DebitoDTO> getDebitoBloquetoPorIdParcelamento(DebitoBloquetoMobileDTO debitoBloquetoMobileDTO) {
        List debitosParcelamento = this.debitoMobileRepository.findDebitoPorIdParcelamento(debitoBloquetoMobileDTO.getIdParcelamento());
        ArrayList<DebitoDTO> debitoBloqueto = new ArrayList<DebitoDTO>();
        debitosParcelamento.forEach(debito -> debitoBloqueto.addAll(this.generateDebitoBloqueto(debito, debitoBloquetoMobileDTO.getParcelas())));
        return debitoBloqueto;
    }

    private List<DebitoDTO> generateDebitoBloqueto(DebitoDTO debito, List<Integer> parcelas) {
        return parcelas.stream().map(m -> {
            DebitoDTO debitoRetorno = new DebitoDTO();
            debitoRetorno.setEntidade(debito.getEntidade());
            debitoRetorno.setExercicio(debito.getExercicio());
            debitoRetorno.setTipoCadastro(debito.getTipoCadastro());
            debitoRetorno.setCadastroGeral(debito.getCadastroGeral());
            debitoRetorno.setGuiaRecolhimento(debito.getGuiaRecolhimento());
            debitoRetorno.setSubDivida(debito.getSubDivida());
            debitoRetorno.setParcela(Long.valueOf(m.longValue()));
            debitoRetorno.setPessoa(debito.getPessoa());
            debitoRetorno.setIdDebito(debito.getIdDebito());
            return debitoRetorno;
        }).collect(Collectors.toList());
    }
}

