/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoOperacaoTce;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoItemDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorDiarioArrecadacaoDTO;
import br.com.elotech.tributos.repository.integracaocontabil.DiarioArrecadacaoRepository;
import br.com.elotech.tributos.service.TipoOperacaoTceService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DiarioArrecadacaoService {
    private final DiarioArrecadacaoRepository diarioArrecadacaoRepository;
    private final EntidadeServiceImpl entidadeServiceImpl;
    private final TipoOperacaoTceService tipoOperacaoTceService;

    public DiarioArrecadacaoService(DiarioArrecadacaoRepository diarioArrecadacaoRepository, EntidadeServiceImpl entidadeServiceImpl, TipoOperacaoTceService tipoOperacaoTceService) {
        this.diarioArrecadacaoRepository = diarioArrecadacaoRepository;
        this.entidadeServiceImpl = entidadeServiceImpl;
        this.tipoOperacaoTceService = tipoOperacaoTceService;
    }

    public Page<DiarioArrecadacaoItemDTO> findDiariosArrecadacao(FiltroDiarioArrecadacaoDTO filtro, Pageable pageable) {
        Entidade entidade = (Entidade)this.entidadeServiceImpl.getEntidadePrincipal().orElseThrow(() -> new EloValidationException("Entidade principal n\u00e3o encontrada."));
        this.verifyUnidadeFederacaoPermitida(entidade.getUnidadeFederacao());
        TipoOperacaoTce tipoOperacaoTcePadrao = this.tipoOperacaoTceService.findTipoOperacaoTcePadrao(entidade.getUnidadeFederacao());
        return this.diarioArrecadacaoRepository.findDiariosArrecadacao(filtro, entidade.getId(), tipoOperacaoTcePadrao, pageable);
    }

    public TotalizadorDiarioArrecadacaoDTO getTotalizador(FiltroDiarioArrecadacaoDTO filtro) {
        Entidade entidade = (Entidade)this.entidadeServiceImpl.getEntidadePrincipal().orElseThrow(() -> new EloValidationException("Entidade principal n\u00e3o encontrada."));
        this.verifyUnidadeFederacaoPermitida(entidade.getUnidadeFederacao());
        return this.diarioArrecadacaoRepository.getTotalizador(filtro, entidade.getId());
    }

    private void verifyUnidadeFederacaoPermitida(String uf) {
        String ufParana = "PR";
        if (!"PR".equalsIgnoreCase(uf)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel listar o di\u00e1rio de arrecada\u00e7\u00e3o para unidade de federa\u00e7\u00e3o \"%s\".", uf));
        }
    }
}

