/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Service;

@Service(value="sequenceCadastroGeralService")
public class SequenceCadastroGeralService {
    private static final String SEQUENCE_IMOBILIARIO_CODIGO = "S05CODIGOIMOBILIARIO";
    private static final String SEQUENCE_IMOBILIARIO_CADASTRO = "S05CDSCADASTROIMOBILIARIO";
    private static final String SEQUENCE_AVULSO = "S05CDSCADASTROAVULSO";
    private static final String SEQUENCE_MOBILIARIO = "S05CDSCADASTROMOBILIARIO";
    private static final String SEQUENCE_RURAL = "S05CDSCADASTRORURAL";
    private final ParametroGeralService parametroGeralService;
    private final ParametroEntidadeService parametroEntidadeService;

    public SequenceCadastroGeralService(ParametroGeralService parametroGeralService, ParametroEntidadeService parametroEntidadeService) {
        this.parametroGeralService = parametroGeralService;
        this.parametroEntidadeService = parametroEntidadeService;
    }

    public String getExpression(CadastroGeral cadastroGeral) {
        StringBuilder sequenceName = new StringBuilder();
        if (cadastroGeral.getTipoCadastro().isImobiliario().booleanValue()) {
            if (!(this.utilizaSetorImobiliario() || this.informaCadastroManual() || this.codigoImobiliarioSequencial())) {
                sequenceName.append(SEQUENCE_IMOBILIARIO_CADASTRO);
            } else if (this.codigoImobiliarioSequencial()) {
                sequenceName.append(SEQUENCE_IMOBILIARIO_CODIGO);
            }
        } else if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            sequenceName.append(SEQUENCE_MOBILIARIO);
        } else if (cadastroGeral.getTipoCadastro().isRural().booleanValue()) {
            sequenceName.append(SEQUENCE_RURAL);
        } else if (cadastroGeral.getTipoCadastro().isAvulso().booleanValue()) {
            sequenceName.append(SEQUENCE_AVULSO);
        } else {
            throw new NotImplementedException("N\u00e3o foi implementado o gerenciamento da sequ\u00eancia para este Tipo de Cadastro");
        }
        return sequenceName.toString();
    }

    private boolean utilizaSetorImobiliario() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SETOR_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean informaCadastroManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean codigoImobiliarioSequencial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_IMOBILIARIO_SEQUENCIAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

