/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoteamentoService
extends CrudService<Loteamento, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final SetorQuadraService setorQuadraService;

    public LoteamentoService(CadastroImobiliarioService cadastroImobiliarioService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, SetorQuadraService setorQuadraService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.setorQuadraService = setorQuadraService;
    }

    protected void beforeSave(Loteamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setUsuario(UsuarioUtils.getUsuarioAise());
        entity.setDataAlteracao(LocalDate.now());
    }

    protected void beforeDelete(Loteamento entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        List quadras = this.setorQuadraService.findByLoteamentoId(entity.getId());
        if (!quadras.isEmpty()) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com a %s", entity.getLoteamento(), this.configuracaoInscricaoCadastralService.getConfiguracao().getQuadra().getDescricao()));
        }
        if (Boolean.TRUE.equals(this.cadastroImobiliarioService.existsCadastroImobiliarioAssociadoLoteamento(entity.getId()))) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com o Cadastro Imobili\u00e1rio", entity.getLoteamento()));
        }
    }
}

