/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaLogradouro;
import br.com.elotech.tributos.dto.LogradouroTestadaRespostaDTO;
import br.com.elotech.tributos.repository.LogradouroTestadaRepository;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LogradouroTestadaService
extends CrudService<LogradouroTestada, Long> {
    private final LogradouroTestadaRepository repository;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final SetorQuadraService setorQuadraService;
    private final RespostaService respostaService;

    public LogradouroTestadaService(LogradouroTestadaRepository repository, CadastroImobiliarioService cadastroImobiliarioService, SetorQuadraService setorQuadraService, RespostaService respostaService) {
        this.repository = repository;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.setorQuadraService = setorQuadraService;
        this.respostaService = respostaService;
    }

    protected void beforeSave(LogradouroTestada entity, Authentication authentication) {
        this.repository.existsLogradouroTestadaComConflito(entity.getId(), entity.getSetorQuadra().getId(), entity.getFaceQuadra(), entity.getLogradouro().getId()).ifPresent(conflito -> {
            throw new EloValidationException(String.format("O logradouro testada %d j\u00e1 possui o mesmo distrito/setor/quadra/logradouro/face quadra.", conflito.getId()));
        });
        if (Objects.nonNull(entity.getSetorQuadra()) && Objects.nonNull(entity.getSetorQuadra().getId())) {
            SetorQuadra setorQuadra = (SetorQuadra)this.setorQuadraService.findOne((Serializable)entity.getSetorQuadra().getId());
            entity.setSetorQuadra(setorQuadra);
        }
        super.beforeSave((EloEntity)entity, authentication);
    }

    protected void beforeDelete(LogradouroTestada entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (this.cadastroImobiliarioService.existsCadastroImobiliarioAssociadoLogradouroTestada(entity.getId()).booleanValue()) {
            throw new EloValidationException("Esse logradouro testada j\u00e1 est\u00e1 associado \u00e0 um cadastro imobili\u00e1rio.");
        }
    }

    public LogradouroTestadaRespostaDTO findByIdLogradouroTestadaResposta(Long id) {
        return this.findById((Serializable)id).map(arg_0 -> this.getRespostasDTO(arg_0)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o logradouro testada com id: %d.", id)));
    }

    public LogradouroTestadaRespostaDTO saveRespostas(Long id, LogradouroTestadaRespostaDTO dto) {
        return this.findById((Serializable)id).map(logradouroTestadaFound -> {
            ArrayList respostasConverted = new ArrayList();
            dto.getRespostasLogradouro().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> respostasConverted.add(resposta.copyTo((Resposta)new RespostaLogradouro()))));
            logradouroTestadaFound.mergeRespostasLogradouro(respostasConverted);
            this.respostaService.validaRespostas(logradouroTestadaFound.getRespostasLogradouro(), FuncionalidadeCampo.LOGRADOURO);
            LogradouroTestada logradouroTestadaSaved = (LogradouroTestada)this.save((EloEntity)logradouroTestadaFound, null);
            return this.getRespostasDTO(logradouroTestadaSaved);
        }).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o logradouro testada com id: %d.", id)));
    }

    public LogradouroTestadaRespostaDTO getRespostasDTO(LogradouroTestada logradouroTestada) {
        List respostasAgrupadas = this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.LOGRADOURO, logradouroTestada.getId());
        return LogradouroTestadaRespostaDTO.of((LogradouroTestada)logradouroTestada, (List)respostasAgrupadas);
    }
}

