/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.FacetCategoriaDTO;
import br.com.elotech.tributos.dto.SelectedFacetDTO;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.hibernate.CacheMode;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HibernateSearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateSearchService.class);
    private final EntityManager entityManager;

    public HibernateSearchService(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional
    public void indexEntities(Class<?> entityType) throws InterruptedException {
        LOGGER.info(String.format("Iniciando a indexa\u00e7\u00e3o das entidades de %s.", entityType.getName()));
        int numeroMaximoThreads = Runtime.getRuntime().availableProcessors();
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        fullTextEntityManager.createIndexer(new Class[]{entityType}).purgeAllOnStart(true).batchSizeToLoadObjects(25).cacheMode(CacheMode.NORMAL).idFetchSize(150).threadsToLoadObjects(numeroMaximoThreads).startAndWait();
        LOGGER.info(String.format("Finalizada a indexa\u00e7\u00e3o das entidades de %s.", entityType.getName()));
    }

    public <T> void indexEntity(T entity) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        fullTextEntityManager.index(entity);
        fullTextEntityManager.flushToIndexes();
    }

    public FullTextQuery searchEntities(HibernateSearchParams hibernateSearchParams, Query query, List<SelectedFacetDTO> selectedFacetsDTO) {
        FullTextQuery fullTextQuery = hibernateSearchParams.createFullTextQuery(query);
        hibernateSearchParams.getFacets().forEach(facetField -> this.enableFacet(hibernateSearchParams.getQueryBuilder(), fullTextQuery, facetField));
        selectedFacetsDTO.forEach(facetSelecionado -> this.aplicaFacetSelecionado(fullTextQuery, facetSelecionado));
        return fullTextQuery;
    }

    public Map<String, FacetCategoriaDTO> getFacetsDisponiveis(FacetManager facetManager, List<FacetField> facets, List<SelectedFacetDTO> selectedFacetsDTO) {
        this.desmarcaFacetsSelecionadosIndisponiveisDevidoAOutrosFacets(facetManager, selectedFacetsDTO);
        return this.getFacetsDisponiveisParaSelecao(facetManager, facets);
    }

    private void desmarcaFacetsSelecionadosIndisponiveisDevidoAOutrosFacets(FacetManager facetManager, List<SelectedFacetDTO> selectedFacetsDTO) {
        selectedFacetsDTO.forEach(selectedFacetDTO -> {
            List selectedFacets = facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).getSelectedFacets();
            if (facetManager.getFacets(selectedFacetDTO.getFacetName()).stream().noneMatch(facet -> facet.getValue().equals(selectedFacetDTO.getFacetValue()))) {
                Facet facet2 = selectedFacets.stream().filter(selectFacet -> selectFacet.getValue().equals(selectedFacetDTO.getFacetValue())).findFirst().orElse(null);
                facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).deselectFacets(new Facet[]{facet2});
            }
        });
    }

    private Map<String, FacetCategoriaDTO> getFacetsDisponiveisParaSelecao(FacetManager facetManager, List<FacetField> facets) {
        LinkedHashMap<String, FacetCategoriaDTO> facetsDisponiveis = new LinkedHashMap<String, FacetCategoriaDTO>();
        facets.forEach(facetField -> {
            ArrayList facetsSelecionados = new ArrayList(facetManager.getFacetGroup(facetField.getName()).getSelectedFacets());
            facetManager.getFacetGroup(facetField.getName()).clearSelectedFacets();
            facetsDisponiveis.put(facetField.getName(), FacetCategoriaDTO.of((FacetField)facetField, (List)facetManager.getFacets(facetField.getName())));
            facetManager.getFacetGroup(facetField.getName()).selectFacets(facetsSelecionados.toArray(new Facet[0]));
        });
        return facetsDisponiveis;
    }

    private void enableFacet(QueryBuilder queryBuilder, FullTextQuery fullTextQuery, FacetField facetField) {
        FacetManager facetManager = fullTextQuery.getFacetManager();
        FacetingRequest facetingRequest = facetField.getIsRangeType() != false ? this.createRangeFacetingRequest(queryBuilder, facetField.getName()) : this.createDiscreteFacetingRequest(queryBuilder, facetField.getName());
        facetManager.enableFaceting(facetingRequest);
    }

    private FacetingRequest createRangeFacetingRequest(QueryBuilder queryBuilder, String facetName) {
        return queryBuilder.facet().name(facetName).onField(facetName).range().below((Object)50).from((Object)51).to((Object)100).from((Object)101).to((Object)250).from((Object)251).to((Object)500).from((Object)501).to((Object)1000).above((Object)1001).orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).createFacetingRequest();
    }

    private FacetingRequest createDiscreteFacetingRequest(QueryBuilder queryBuilder, String facetName) {
        int numeroMaximoFacets = 1000000;
        return queryBuilder.facet().name(facetName).onField(facetName).discrete().orderedBy(FacetSortOrder.FIELD_VALUE).includeZeroCounts(false).maxFacetCount(1000000).createFacetingRequest();
    }

    private void aplicaFacetSelecionado(FullTextQuery fullTextQuery, SelectedFacetDTO selectedFacetDTO) {
        FacetManager facetManager = fullTextQuery.getFacetManager();
        if (fullTextQuery.getResultSize() > 0) {
            ArrayList facetsJaSelecionados = new ArrayList(facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).getSelectedFacets());
            facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).clearSelectedFacets();
            List facetsDisponiveis = facetManager.getFacets(selectedFacetDTO.getFacetName());
            Facet[] facetsDisponiveisSelecionados = (Facet[])facetsDisponiveis.stream().filter(facetDisponivel -> facetDisponivel.getValue().equals(selectedFacetDTO.getFacetValue()) || facetsJaSelecionados.contains(facetDisponivel)).toArray(Facet[]::new);
            facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).selectFacets(facetsDisponiveisSelecionados);
        }
    }

    public <A, B> CadastroSearchDTO<B> geraCadastroSearchDTO(Query query, HibernateSearchParams hibernateSearchParams, List<SelectedFacetDTO> selectedFacetsDTO, Function<A, B> converteEntityToDTO) {
        FullTextQuery fullTextQuery = this.searchEntities(hibernateSearchParams, query, selectedFacetsDTO);
        CadastroSearchDTO dto = new CadastroSearchDTO();
        dto.setFacets(this.getFacetsDisponiveis(fullTextQuery.getFacetManager(), hibernateSearchParams.getFacets(), selectedFacetsDTO));
        List cadastros = fullTextQuery.getResultList().stream().map(converteEntityToDTO).collect(Collectors.toList());
        dto.setCadastros((Page)new PageImpl(cadastros, hibernateSearchParams.getPageable(), (long)fullTextQuery.getResultSize()));
        return dto;
    }
}

