/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.dto.CadastroAvulsoDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.VinculoService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CadastroAvulsoService {
    public static final long VINCULO_PRINCIPAL = 1L;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final PessoaService pessoaService;
    private final VinculoService vinculoService;
    private final ParametroGeralService parametroGeralService;
    private final RespostaService respostaService;

    public CadastroAvulsoService(CadastroGeralRepository cadastroGeralRepository, PessoaService pessoaService, VinculoService vinculoService, ParametroGeralService parametroGeralService, RespostaService respostaService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.pessoaService = pessoaService;
        this.vinculoService = vinculoService;
        this.parametroGeralService = parametroGeralService;
        this.respostaService = respostaService;
    }

    private static CadastroGeral from(Pessoa pessoa) {
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setTipoCadastro(TipoCadastro.AVULSO);
        cadastroGeral.setPessoa(pessoa);
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        if (Objects.nonNull(enderecoPrincipal)) {
            cadastroGeral.setBairro(enderecoPrincipal.getBairro());
            cadastroGeral.setLogradouro(enderecoPrincipal.getLogradouro());
            cadastroGeral.setComplemento(enderecoPrincipal.getComplemento());
            cadastroGeral.setCidade(enderecoPrincipal.getCidade());
            cadastroGeral.setNumero(enderecoPrincipal.getNumero());
            cadastroGeral.setCep(enderecoPrincipal.getCep());
        }
        return cadastroGeral;
    }

    public IncluirPessoaAndCadastroAvulsoResponseDTO incluirCadastroAvulsoEPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        Pessoa pessoa = this.pessoaService.incluirPessoa(incluirPessoaRequestDTO);
        CadastroGeral cadastroAvulso = this.findByPessoaId(pessoa.getId()).stream().findFirst().orElseGet(() -> this.gerarParaPessoa(pessoa));
        return IncluirPessoaAndCadastroAvulsoResponseDTO.of((CadastroGeral)cadastroAvulso);
    }

    private CadastroGeral gerarParaPessoa(Pessoa pessoa) {
        Vinculo vinculoPrincipal = new Vinculo();
        vinculoPrincipal.setId(Long.valueOf(1L));
        CadastroGeral cadastroAvulso = CadastroAvulsoService.from((Pessoa)pessoa);
        Proprietario proprietario = new Proprietario();
        proprietario.setPessoa(pessoa);
        proprietario.setPrincipal(Boolean.TRUE);
        proprietario.setPercentual(new BigDecimal("100"));
        proprietario.setVinculo(vinculoPrincipal);
        cadastroAvulso.getProprietarios().add(proprietario);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastroAvulso);
    }

    private List<CadastroGeral> findByPessoaId(Long pessoa) {
        return this.cadastroGeralRepository.findByPessoaIdAndTipoCadastroAndExclusaoLogicaFalse(pessoa, TipoCadastro.AVULSO);
    }

    public CadastroAvulsoDTO findCadastroAvulso(Long idCadastroAvulso) {
        return this.loadDTO(this.buscaCadastroAvulso(idCadastroAvulso));
    }

    private CadastroGeral buscaCadastroAvulso(Long idCadastroAvulso) {
        return (CadastroGeral)this.cadastroGeralRepository.findById((Object)idCadastroAvulso).orElseThrow(() -> new EloValidationException("Cadastro avulso n\u00e3o encontrado."));
    }

    public Boolean existsByCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralRepository.existsByTipoCadastroAndPessoaCnpjCpfAndExclusaoLogicaFalse(TipoCadastro.AVULSO, cnpjCpf);
    }

    public CadastroGeral beforeSave(CadastroAvulsoDTO cadastroAvulsoDTO) {
        this.beforeToEntityValidation(cadastroAvulsoDTO);
        CadastroGeral cadastroAvulso = cadastroAvulsoDTO.toEntity();
        Proprietario proprietarioPrincipal = new Proprietario();
        proprietarioPrincipal.setPessoa(cadastroAvulsoDTO.getProprietarioPrincipal());
        proprietarioPrincipal.setPrincipal(Boolean.TRUE);
        proprietarioPrincipal.setVinculo(this.vinculoService.findVinculoByTipoVinculo(TipoVinculo.PRINCIPAL));
        proprietarioPrincipal.setPercentual(BigDecimal.valueOf(100L));
        cadastroAvulso.getProprietarios().add(proprietarioPrincipal);
        return cadastroAvulso;
    }

    public CadastroAvulsoDTO save(CadastroAvulsoDTO cadastroAvulsoDTO) {
        return Optional.of(cadastroAvulsoDTO).map(arg_0 -> this.beforeSave(arg_0)).map(arg_0 -> this.save(arg_0)).map(arg_0 -> this.loadDTO(arg_0)).get();
    }

    public CadastroAvulsoDTO update(Long id, CadastroAvulsoDTO cadastroAvulsoDTO) {
        return Optional.of(cadastroAvulsoDTO).map(arg_0 -> this.beforeSave(arg_0)).map(cadastroAvulsoToSave -> this.merge(id, cadastroAvulsoToSave)).map(arg_0 -> this.save(arg_0)).map(arg_0 -> this.loadDTO(arg_0)).get();
    }

    private CadastroGeral save(CadastroGeral cadastroAvulso) {
        this.respostaService.validaRespostas(cadastroAvulso.getRespostasAvulso(), FuncionalidadeCampo.AVULSO);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastroAvulso);
    }

    public CadastroAvulsoDTO loadDTO(CadastroGeral cadastroAvulso) {
        CadastroAvulsoDTO retorno = CadastroAvulsoDTO.from((CadastroGeral)cadastroAvulso);
        retorno.setRespostasAvulso(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.AVULSO, retorno.getId()));
        return retorno;
    }

    public CadastroGeral merge(Long id, CadastroGeral cadastroAvulsoToMerge) {
        CadastroGeral cadastroAvulsoFound = this.buscaCadastroAvulso(id);
        if (cadastroAvulsoFound.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException("Cadastro avulso est\u00e1 inativo.");
        }
        if (!cadastroAvulsoFound.getId().equals(cadastroAvulsoToMerge.getId())) {
            throw new EloValidationException("Para fazer o merge, os cadastros devem ter o mesmo id.");
        }
        cadastroAvulsoFound.setLogradouro(cadastroAvulsoToMerge.getLogradouro());
        cadastroAvulsoFound.setPessoa(cadastroAvulsoToMerge.getPessoa());
        cadastroAvulsoFound.setNumero(cadastroAvulsoToMerge.getNumero());
        cadastroAvulsoFound.setComplemento(cadastroAvulsoToMerge.getComplemento());
        cadastroAvulsoFound.setBairro(cadastroAvulsoToMerge.getBairro());
        cadastroAvulsoFound.setCidade(cadastroAvulsoToMerge.getCidade());
        cadastroAvulsoFound.setUsuario(cadastroAvulsoToMerge.getUsuario());
        cadastroAvulsoFound.setDataAlteracao(LocalDate.now());
        cadastroAvulsoFound.mergeProprietarios(cadastroAvulsoToMerge.getProprietarios());
        cadastroAvulsoFound.addObservacoes(cadastroAvulsoToMerge.getObservacoes());
        cadastroAvulsoFound.mergeRespostaAvulso(cadastroAvulsoToMerge.getRespostasAvulso());
        return cadastroAvulsoFound;
    }

    private void beforeToEntityValidation(CadastroAvulsoDTO cadastroAvulsoDTO) {
        if (!this.codigoAvulsoSequencial() && Objects.isNull(cadastroAvulsoDTO.getCodigo())) {
            throw new EloValidationException("C\u00f3digo do cadastro \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroAvulsoDTO.getProprietarioPrincipal())) {
            throw new EloValidationException("Contribuinte \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroAvulsoDTO.getProprietarioPrincipal().getCnpjCpf())) {
            throw new EloValidationException("CPF/CNPJ \u00e9 obrigat\u00f3rio.");
        }
        cadastroAvulsoDTO.getResponsaveis().forEach(proprietario -> {
            if (Objects.isNull(proprietario.getPessoa())) {
                throw new EloValidationException("Respons\u00e1vel \u00e9 obrigat\u00f3rio.");
            }
            if (Objects.isNull(proprietario.getVinculo())) {
                throw new EloValidationException("V\u00ednculo \u00e9 obrigat\u00f3rio.");
            }
        });
    }

    private boolean codigoAvulsoSequencial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_AVULSO_SEQUENCIAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public void delete(Long idCadastroAvulso) {
        this.cadastroGeralRepository.delete((Object)this.buscaCadastroAvulso(idCadastroAvulso));
    }
}

