/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroTestadaGeomaisDTO;
import br.com.elotech.tributos.service.LogradouroTestadaService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/logradouro-testada"})
public class LogradouroTestadaGeomaisResource {
    private final LogradouroTestadaService logradouroTestadaService;

    public LogradouroTestadaGeomaisResource(LogradouroTestadaService logradouroTestadaService) {
        this.logradouroTestadaService = logradouroTestadaService;
    }

    @GetMapping
    public ResponseEntity<Page<LogradouroTestadaGeomaisDTO>> findAll(Pageable page) {
        Page testadas = this.logradouroTestadaService.findAll(page).map(LogradouroTestadaGeomaisDTO::from);
        return ResponseEntity.ok((Object)testadas);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTestadaGeomaisDTO> findById(@PathVariable Long id) {
        LogradouroTestadaGeomaisDTO logradouroTestadaGeomaisDTO = this.logradouroTestadaService.findById((Serializable)id).map(LogradouroTestadaGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Logradouro Testada com o id '%d'.", id)));
        return ResponseEntity.ok((Object)logradouroTestadaGeomaisDTO);
    }
}

