/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.CondominioGeomaisDTO;
import br.com.elotech.tributos.service.CondominioService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/condominio"})
public class CondominioGeomaisResource {
    private final CondominioService condominioService;

    public CondominioGeomaisResource(CondominioService condominioService) {
        this.condominioService = condominioService;
    }

    @GetMapping
    public ResponseEntity<Page<CondominioGeomaisDTO>> findAll(Pageable page) {
        Page condominios = this.condominioService.findAll(page).map(CondominioGeomaisDTO::from);
        return ResponseEntity.ok((Object)condominios);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CondominioGeomaisDTO> findById(@PathVariable Long id) {
        CondominioGeomaisDTO condominioDTO = this.condominioService.findById((Serializable)id).map(CondominioGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Condom\u00ednio com o id '%d'.", id)));
        return ResponseEntity.ok((Object)condominioDTO);
    }
}

