/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.camposdinamicos;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface RespostaRepository
extends CrudRepository<Resposta, Long> {
    @Query(value=" select new br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO(c, gc, rt)  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno rt on c.id = rt.campo.id and rt.cadastroImobiliario.id = :referencia  where gc.funcionalidade = 'TERRENO' ")
    public List<RespostaDTO> getRespostasFromTerreno(@Param(value="referencia") Long var1);

    @Query(value=" select rt  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno rt on c.id = rt.campo.id and rt.cadastroImobiliario.id = :referencia  where gc.funcionalidade = 'TERRENO'  and rt.campo.id = :idCampoDinamico ")
    public List<RespostaTerreno> getRespostasTerrenoFilterByCampo(@Param(value="referencia") Long var1, @Param(value="idCampoDinamico") Long var2);

    @Query(value=" select new br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO(c, gc, rs)  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento rs on c.id = rs.campo.id and rs.segmento.id = :referencia  where gc.funcionalidade = 'SEGMENTO' ")
    public List<RespostaDTO> getRespostasFromSegmento(@Param(value="referencia") Long var1);

    @Query(value=" select rs  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento rs on c.id = rs.campo.id and rs.segmento.id = :referencia  where gc.funcionalidade = 'SEGMENTO'  and rs.campo.id = :idCampoDinamico ")
    public List<RespostaSegmento> getRespostasSegmentoFiterByCampo(@Param(value="referencia") Long var1, @Param(value="idCampoDinamico") Long var2);

    @Query(value=" select new br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO(c, gc, rl)  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaLogradouro rl on c.id = rl.campo.id and rl.logradouroTestada.id = :referencia  where gc.funcionalidade = 'LOGRADOURO' ")
    public List<RespostaDTO> getRespostasFromLogradouro(@Param(value="referencia") Long var1);

    @Query(value=" select new br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO(c, gc, ra)  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaAvulso ra on c.id = ra.campo.id and ra.cadastroGeral.id = :referencia  where gc.funcionalidade = 'AVULSO' ")
    public List<RespostaDTO> getRespostasFromAvulso(@Param(value="referencia") Long var1);

    @Query(value=" select new br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO(c, gc, rm)  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario rm on c.id = rm.campo.id and rm.cadastroMobiliario.id = :referencia  where gc.funcionalidade = 'MOBILIARIO' ")
    public List<RespostaDTO> getRespostasFromMobiliario(@Param(value="referencia") Long var1);

    @Query(value=" select rm  from br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo gc  inner join gc.campos c   left join br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario rm on c.id = rm.campo.id and rm.cadastroMobiliario.id = :referencia  where gc.funcionalidade = 'MOBILIARIO'  and rm.campo.id = :idCampoDinamico ")
    public List<RespostaMobiliario> getRespostasMobiliarioFilterByCampo(@Param(value="referencia") Long var1, @Param(value="idCampoDinamico") Long var2);
}

