/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroPagamentoDTO {
    private String pagamento;
    private String exercicioPagamento;
    private String tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subDivida;
    private LocalDate dataMovimento;
    private LocalDate dataPagamento;
    private String contaBancaria;
    private String lote;
    private String exercicioLote;
    private String boleto;
    private String exercicioBoleto;
    private Boolean somenteNaoEstornados = Boolean.FALSE;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    private void validaFiltro() {
        if (StringUtils.isBlank((CharSequence)this.pagamento) && StringUtils.isBlank((CharSequence)this.exercicioPagamento) && StringUtils.isBlank((CharSequence)this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isBlank((CharSequence)this.subDivida) && Objects.isNull(this.dataMovimento) && Objects.isNull(this.dataPagamento) && StringUtils.isBlank((CharSequence)this.contaBancaria) && StringUtils.isBlank((CharSequence)this.lote) && StringUtils.isBlank((CharSequence)this.exercicioLote) && StringUtils.isBlank((CharSequence)this.boleto) && StringUtils.isBlank((CharSequence)this.exercicioBoleto)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio informar ao menos um filtro.");
        }
        this.validaPagamento();
        this.validaFiltroDebito();
        this.validaFiltroCadastro();
        this.validaFiltroBoleto();
        this.validaFiltroLotePagamento();
    }

    private void validaPagamento() {
        if (StringUtils.isBlank((CharSequence)this.pagamento) && StringUtils.isNotBlank((CharSequence)this.exercicioPagamento)) {
            throw new EloValidationException("Informe o pagamento e exerc\u00edcio pagamento.");
        }
    }

    private void validaFiltroCadastro() {
        if (StringUtils.isBlank((CharSequence)this.tipoCadastro) && StringUtils.isNotBlank((CharSequence)this.cadastroGeral) || StringUtils.isNotBlank((CharSequence)this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral)) {
            throw new EloValidationException("Filtro do cadastro est\u00e1 inv\u00e1lido.");
        }
    }

    private void validaFiltroDebito() {
        if (StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            throw new EloValidationException("Informe o tipo cadastro e cadastro do pagamento.");
        }
        if (StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isNotBlank((CharSequence)this.divida)) {
            throw new EloValidationException("Informe o tipo cadastro, cadastro e exerc\u00edcio do pagamento.");
        }
        if (StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            throw new EloValidationException("Informe o tipo cadastro, cadastro, exerc\u00edcio e divida do pagamento.");
        }
    }

    private void validaFiltroBoleto() {
        if (StringUtils.isBlank((CharSequence)this.boleto) && StringUtils.isNotBlank((CharSequence)this.exercicioBoleto)) {
            throw new EloValidationException("Informe o n\u00famero do boleto.");
        }
    }

    private void validaFiltroLotePagamento() {
        if (StringUtils.isBlank((CharSequence)this.exercicioPagamento) && StringUtils.isNotBlank((CharSequence)this.contaBancaria)) {
            throw new EloValidationException("Informe o exerc\u00edcio do pagamento.");
        }
        if (StringUtils.isBlank((CharSequence)this.exercicioLote) && StringUtils.isNotBlank((CharSequence)this.lote)) {
            throw new EloValidationException("Informe o exerc\u00edcio do lote.");
        }
        if (StringUtils.isBlank((CharSequence)this.lote) && StringUtils.isNotBlank((CharSequence)this.exercicioLote)) {
            throw new EloValidationException("Informe o lote do pagamento.");
        }
    }

    public String buildFiltro() {
        this.validaFiltro();
        StringBuilder filtro = new StringBuilder();
        this.filtroPagamento(filtro);
        this.filtroCadastro(filtro);
        this.filtroDebito(filtro);
        if (StringUtils.isNotBlank((CharSequence)this.contaBancaria)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.contaBancaria, (String)"pagamento.contaBancaria.contaBancaria")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.boleto)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.boleto, (String)"boleto.bloqueto")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioBoleto)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioBoleto, (String)"boleto.exercicioBloqueto")));
        }
        if (this.somenteNaoEstornados.booleanValue()) {
            filtro.append(this.addAND("pagamentosDebito.estorno='N'"));
        }
        return filtro.toString();
    }

    private void filtroPagamento(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.pagamento)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.pagamento, (String)"pagamento.id.pagamento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioPagamento)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioPagamento, (String)"pagamento.id.exercicioPagamento")));
        }
        if (Objects.nonNull(this.dataMovimento)) {
            filtro.append(this.addAND("pagamento.dataMovimento=:dataMovimento"));
        }
        if (Objects.nonNull(this.dataPagamento)) {
            filtro.append(this.addAND("pagamento.dataPagamento=:dataPagamento"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.lote)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.lote, (String)"lote.id.lote")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioLote)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioLote, (String)"lote.id.exercicio")));
        }
    }

    private void filtroCadastro(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("debitoParcela.id.tipoCadastro=%s", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debitoParcela.id.cadastroGeral")));
        }
    }

    private void filtroDebito(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"debitoParcela.id.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"debitoParcela.id.divida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"debitoParcela.id.subDivida")));
        }
    }

    public Map<String, LocalDate> getFiltroDatas() {
        HashMap<String, LocalDate> filtros = new HashMap<String, LocalDate>();
        if (Objects.nonNull(this.dataMovimento)) {
            filtros.put("dataMovimento", this.dataMovimento);
        }
        if (Objects.nonNull(this.dataPagamento)) {
            filtros.put("dataPagamento", this.dataPagamento);
        }
        return filtros;
    }

    @Generated
    public FiltroPagamentoDTO() {
    }

    @Generated
    public String getPagamento() {
        return this.pagamento;
    }

    @Generated
    public String getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public String getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getExercicioLote() {
        return this.exercicioLote;
    }

    @Generated
    public String getBoleto() {
        return this.boleto;
    }

    @Generated
    public String getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public Boolean getSomenteNaoEstornados() {
        return this.somenteNaoEstornados;
    }

    @Generated
    public void setPagamento(String pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setExercicioPagamento(String exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setContaBancaria(String contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setExercicioLote(String exercicioLote) {
        this.exercicioLote = exercicioLote;
    }

    @Generated
    public void setBoleto(String boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setExercicioBoleto(String exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setSomenteNaoEstornados(Boolean somenteNaoEstornados) {
        this.somenteNaoEstornados = somenteNaoEstornados;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroPagamentoDTO)) {
            return false;
        }
        FiltroPagamentoDTO other = (FiltroPagamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pagamento = this.getPagamento();
        String other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !this$pagamento.equals(other$pagamento)) {
            return false;
        }
        String this$exercicioPagamento = this.getExercicioPagamento();
        String other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !this$exercicioPagamento.equals(other$exercicioPagamento)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        String this$contaBancaria = this.getContaBancaria();
        String other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$exercicioLote = this.getExercicioLote();
        String other$exercicioLote = other.getExercicioLote();
        if (this$exercicioLote == null ? other$exercicioLote != null : !this$exercicioLote.equals(other$exercicioLote)) {
            return false;
        }
        String this$boleto = this.getBoleto();
        String other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !this$boleto.equals(other$boleto)) {
            return false;
        }
        String this$exercicioBoleto = this.getExercicioBoleto();
        String other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !this$exercicioBoleto.equals(other$exercicioBoleto)) {
            return false;
        }
        Boolean this$somenteNaoEstornados = this.getSomenteNaoEstornados();
        Boolean other$somenteNaoEstornados = other.getSomenteNaoEstornados();
        return !(this$somenteNaoEstornados == null ? other$somenteNaoEstornados != null : !((Object)this$somenteNaoEstornados).equals(other$somenteNaoEstornados));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroPagamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : $pagamento.hashCode());
        String $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : $exercicioPagamento.hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        String $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $exercicioLote = this.getExercicioLote();
        result = result * 59 + ($exercicioLote == null ? 43 : $exercicioLote.hashCode());
        String $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : $boleto.hashCode());
        String $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : $exercicioBoleto.hashCode());
        Boolean $somenteNaoEstornados = this.getSomenteNaoEstornados();
        result = result * 59 + ($somenteNaoEstornados == null ? 43 : ((Object)$somenteNaoEstornados).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroPagamentoDTO(pagamento=" + this.getPagamento() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataMovimento=" + this.getDataMovimento() + ", dataPagamento=" + this.getDataPagamento() + ", contaBancaria=" + this.getContaBancaria() + ", lote=" + this.getLote() + ", exercicioLote=" + this.getExercicioLote() + ", boleto=" + this.getBoleto() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", somenteNaoEstornados=" + this.getSomenteNaoEstornados() + ")";
    }
}

