/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.PessoaDTO;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroGeralDTO {
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long pessoa;
    private Long logradouro;
    private Long cidade;
    private Long bairro;
    private Long cep;
    private String numero;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private Long sequenciaEndereco;
    private String exclusaoLogica = "N";
    private String tipoImovel;
    private PessoaDTO pessoaDTO;
    private String zona;
    private String quadra;
    private String data;
    private String inscricaoCadastral;
    private String cidadeCadastro;
    private String ufCadastro;
    private String bairroCadastro;
    private String tipoLogradouroCadastro;
    private String logradouroCadastro;
    private String numeroCadastro;
    private String cepCadastro;
    private String complementoCadastro;
    private String complementoLoteCadastro;

    private CadastroGeralDTO clearFields() {
        this.setPessoa(null);
        return this;
    }

    public CadastroGeralDTO set() {
        PessoaDTO dto = new PessoaDTO();
        Optional.ofNullable(this.pessoaDTO.getPessoa()).ifPresent(arg_0 -> ((PessoaDTO)dto).setPessoa(arg_0));
        Optional.ofNullable(this.pessoaDTO.getCnpjCpf()).ifPresent(arg_0 -> ((PessoaDTO)dto).setCnpjCpf(arg_0));
        Optional.ofNullable(this.pessoaDTO.getTipoPessoa()).ifPresent(arg_0 -> ((PessoaDTO)dto).setTipoPessoa(arg_0));
        Optional.ofNullable(this.pessoaDTO.getNome()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNome(arg_0));
        Optional.ofNullable(this.pessoaDTO.getNomeFantasia()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNomeFantasia(arg_0));
        Optional.ofNullable(this.pessoaDTO.getCidade()).ifPresent(arg_0 -> ((PessoaDTO)dto).setCidade(arg_0));
        Optional.ofNullable(this.pessoaDTO.getUf()).ifPresent(arg_0 -> ((PessoaDTO)dto).setUf(arg_0));
        Optional.ofNullable(this.pessoaDTO.getBairro()).ifPresent(arg_0 -> ((PessoaDTO)dto).setBairro(arg_0));
        Optional.ofNullable(this.pessoaDTO.getTipoLogradouro()).ifPresent(arg_0 -> ((PessoaDTO)dto).setTipoLogradouro(arg_0));
        Optional.ofNullable(this.pessoaDTO.getLogradouro()).ifPresent(arg_0 -> ((PessoaDTO)dto).setLogradouro(arg_0));
        Optional.ofNullable(this.pessoaDTO.getNumero()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNumero(arg_0));
        Optional.ofNullable(this.pessoaDTO.getNumero()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNumero(arg_0));
        Optional.ofNullable(this.pessoaDTO.getComplemento()).ifPresent(arg_0 -> ((PessoaDTO)dto).setComplemento(arg_0));
        Optional.ofNullable(this.pessoaDTO.getCep()).ifPresent(arg_0 -> ((PessoaDTO)dto).setCep(arg_0));
        this.clearFields();
        this.setPessoaDTO(dto);
        return this;
    }

    private static CadastroGeralDTO loadCadastro(CadastroGeral cadastro) {
        CadastroGeralDTO dto = new CadastroGeralDTO();
        Optional.ofNullable(cadastro.getTipoCadastro().getValue()).ifPresent(arg_0 -> dto.setTipoCadastro(arg_0));
        Optional.ofNullable(cadastro.getCadastroGeral()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(cadastro.getCidade()).ifPresent(cidade -> dto.setCidadeCadastro(cidade.getDescricao()));
        Optional.ofNullable(cadastro.getCidade()).ifPresent(cidade -> dto.setUfCadastro(cidade.getUnidadeFederacao()));
        Optional.ofNullable(cadastro.getBairro()).ifPresent(bairro -> dto.setBairroCadastro(bairro.getDescricao()));
        Optional.ofNullable(cadastro.getLogradouro()).ifPresent(logradouro -> dto.setTipoLogradouroCadastro(logradouro.getTipoLogradouroDescricao()));
        Optional.ofNullable(cadastro.getLogradouro()).ifPresent(logradouro -> dto.setLogradouroCadastro(logradouro.getDescricao()));
        Optional.ofNullable(cadastro.getNumero()).ifPresent(arg_0 -> dto.setNumeroCadastro(arg_0));
        Optional.ofNullable(cadastro.getCep()).ifPresent(cep -> dto.setCepCadastro(cep.toString()));
        Optional.ofNullable(cadastro.getComplemento()).ifPresent(arg_0 -> dto.setComplementoCadastro(arg_0));
        Optional.ofNullable(cadastro.getDataInclusao()).ifPresent(arg_0 -> dto.setDataInclusao(arg_0));
        Optional.ofNullable(cadastro.getDataAlteracao()).ifPresent(arg_0 -> dto.setDataAlteracao(arg_0));
        return dto;
    }

    public static CadastroGeralDTO from(CadastroGeral cadastro) {
        return CadastroGeralDTO.loadCadastro((CadastroGeral)cadastro);
    }

    public static CadastroGeralDTO fromWithPessoa(CadastroGeral cadastro) {
        CadastroGeralDTO dto = CadastroGeralDTO.loadCadastro((CadastroGeral)cadastro);
        if (Objects.nonNull(cadastro.getPessoa())) {
            PessoaDTO pessoaDTO = new PessoaDTO();
            pessoaDTO.setPessoa(cadastro.getPessoa().getId());
            pessoaDTO.setCnpjCpf(cadastro.getPessoa().getCnpjCpf());
            pessoaDTO.setNome(cadastro.getPessoa().getNome());
            dto.setPessoaDTO(pessoaDTO);
        }
        return dto;
    }

    public static CadastroGeralDTO from(CadastroImobiliario imobiliario) {
        CadastroGeralDTO dto = CadastroGeralDTO.loadCadastro((CadastroGeral)imobiliario);
        Optional.ofNullable(imobiliario.getComplementoLote()).ifPresent(arg_0 -> dto.setComplementoLoteCadastro(arg_0));
        Optional.ofNullable(imobiliario.getSetorLocalizacao()).ifPresent(setor -> dto.setZona(setor.getSetor()));
        Optional.ofNullable(imobiliario.getQuadraLocalizacao()).map(SetorQuadra::getQuadra).ifPresent(arg_0 -> dto.setQuadra(arg_0));
        Optional.ofNullable(imobiliario.getLoteLocalizacao()).ifPresent(arg_0 -> dto.setData(arg_0));
        Optional.ofNullable(imobiliario.getInscricaoCadastral()).ifPresent(arg_0 -> dto.setInscricaoCadastral(arg_0));
        return dto;
    }

    @Generated
    public CadastroGeralDTO() {
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public Long getCidade() {
        return this.cidade;
    }

    @Generated
    public Long getBairro() {
        return this.bairro;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    @Generated
    public String getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public String getTipoImovel() {
        return this.tipoImovel;
    }

    @Generated
    public PessoaDTO getPessoaDTO() {
        return this.pessoaDTO;
    }

    @Generated
    public String getZona() {
        return this.zona;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getCidadeCadastro() {
        return this.cidadeCadastro;
    }

    @Generated
    public String getUfCadastro() {
        return this.ufCadastro;
    }

    @Generated
    public String getBairroCadastro() {
        return this.bairroCadastro;
    }

    @Generated
    public String getTipoLogradouroCadastro() {
        return this.tipoLogradouroCadastro;
    }

    @Generated
    public String getLogradouroCadastro() {
        return this.logradouroCadastro;
    }

    @Generated
    public String getNumeroCadastro() {
        return this.numeroCadastro;
    }

    @Generated
    public String getCepCadastro() {
        return this.cepCadastro;
    }

    @Generated
    public String getComplementoCadastro() {
        return this.complementoCadastro;
    }

    @Generated
    public String getComplementoLoteCadastro() {
        return this.complementoLoteCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setCidade(Long cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    @Generated
    public void setExclusaoLogica(String exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setTipoImovel(String tipoImovel) {
        this.tipoImovel = tipoImovel;
    }

    @Generated
    public void setPessoaDTO(PessoaDTO pessoaDTO) {
        this.pessoaDTO = pessoaDTO;
    }

    @Generated
    public void setZona(String zona) {
        this.zona = zona;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setCidadeCadastro(String cidadeCadastro) {
        this.cidadeCadastro = cidadeCadastro;
    }

    @Generated
    public void setUfCadastro(String ufCadastro) {
        this.ufCadastro = ufCadastro;
    }

    @Generated
    public void setBairroCadastro(String bairroCadastro) {
        this.bairroCadastro = bairroCadastro;
    }

    @Generated
    public void setTipoLogradouroCadastro(String tipoLogradouroCadastro) {
        this.tipoLogradouroCadastro = tipoLogradouroCadastro;
    }

    @Generated
    public void setLogradouroCadastro(String logradouroCadastro) {
        this.logradouroCadastro = logradouroCadastro;
    }

    @Generated
    public void setNumeroCadastro(String numeroCadastro) {
        this.numeroCadastro = numeroCadastro;
    }

    @Generated
    public void setCepCadastro(String cepCadastro) {
        this.cepCadastro = cepCadastro;
    }

    @Generated
    public void setComplementoCadastro(String complementoCadastro) {
        this.complementoCadastro = complementoCadastro;
    }

    @Generated
    public void setComplementoLoteCadastro(String complementoLoteCadastro) {
        this.complementoLoteCadastro = complementoLoteCadastro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralDTO)) {
            return false;
        }
        CadastroGeralDTO other = (CadastroGeralDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$logradouro = this.getLogradouro();
        Long other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !((Object)this$logradouro).equals(other$logradouro)) {
            return false;
        }
        Long this$cidade = this.getCidade();
        Long other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !((Object)this$cidade).equals(other$cidade)) {
            return false;
        }
        Long this$bairro = this.getBairro();
        Long other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !((Object)this$bairro).equals(other$bairro)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        Long this$sequenciaEndereco = this.getSequenciaEndereco();
        Long other$sequenciaEndereco = other.getSequenciaEndereco();
        if (this$sequenciaEndereco == null ? other$sequenciaEndereco != null : !((Object)this$sequenciaEndereco).equals(other$sequenciaEndereco)) {
            return false;
        }
        String this$exclusaoLogica = this.getExclusaoLogica();
        String other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !this$exclusaoLogica.equals(other$exclusaoLogica)) {
            return false;
        }
        String this$tipoImovel = this.getTipoImovel();
        String other$tipoImovel = other.getTipoImovel();
        if (this$tipoImovel == null ? other$tipoImovel != null : !this$tipoImovel.equals(other$tipoImovel)) {
            return false;
        }
        PessoaDTO this$pessoaDTO = this.getPessoaDTO();
        PessoaDTO other$pessoaDTO = other.getPessoaDTO();
        if (this$pessoaDTO == null ? other$pessoaDTO != null : !this$pessoaDTO.equals(other$pessoaDTO)) {
            return false;
        }
        String this$zona = this.getZona();
        String other$zona = other.getZona();
        if (this$zona == null ? other$zona != null : !this$zona.equals(other$zona)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$inscricaoCadastral = this.getInscricaoCadastral();
        String other$inscricaoCadastral = other.getInscricaoCadastral();
        if (this$inscricaoCadastral == null ? other$inscricaoCadastral != null : !this$inscricaoCadastral.equals(other$inscricaoCadastral)) {
            return false;
        }
        String this$cidadeCadastro = this.getCidadeCadastro();
        String other$cidadeCadastro = other.getCidadeCadastro();
        if (this$cidadeCadastro == null ? other$cidadeCadastro != null : !this$cidadeCadastro.equals(other$cidadeCadastro)) {
            return false;
        }
        String this$ufCadastro = this.getUfCadastro();
        String other$ufCadastro = other.getUfCadastro();
        if (this$ufCadastro == null ? other$ufCadastro != null : !this$ufCadastro.equals(other$ufCadastro)) {
            return false;
        }
        String this$bairroCadastro = this.getBairroCadastro();
        String other$bairroCadastro = other.getBairroCadastro();
        if (this$bairroCadastro == null ? other$bairroCadastro != null : !this$bairroCadastro.equals(other$bairroCadastro)) {
            return false;
        }
        String this$tipoLogradouroCadastro = this.getTipoLogradouroCadastro();
        String other$tipoLogradouroCadastro = other.getTipoLogradouroCadastro();
        if (this$tipoLogradouroCadastro == null ? other$tipoLogradouroCadastro != null : !this$tipoLogradouroCadastro.equals(other$tipoLogradouroCadastro)) {
            return false;
        }
        String this$logradouroCadastro = this.getLogradouroCadastro();
        String other$logradouroCadastro = other.getLogradouroCadastro();
        if (this$logradouroCadastro == null ? other$logradouroCadastro != null : !this$logradouroCadastro.equals(other$logradouroCadastro)) {
            return false;
        }
        String this$numeroCadastro = this.getNumeroCadastro();
        String other$numeroCadastro = other.getNumeroCadastro();
        if (this$numeroCadastro == null ? other$numeroCadastro != null : !this$numeroCadastro.equals(other$numeroCadastro)) {
            return false;
        }
        String this$cepCadastro = this.getCepCadastro();
        String other$cepCadastro = other.getCepCadastro();
        if (this$cepCadastro == null ? other$cepCadastro != null : !this$cepCadastro.equals(other$cepCadastro)) {
            return false;
        }
        String this$complementoCadastro = this.getComplementoCadastro();
        String other$complementoCadastro = other.getComplementoCadastro();
        if (this$complementoCadastro == null ? other$complementoCadastro != null : !this$complementoCadastro.equals(other$complementoCadastro)) {
            return false;
        }
        String this$complementoLoteCadastro = this.getComplementoLoteCadastro();
        String other$complementoLoteCadastro = other.getComplementoLoteCadastro();
        return !(this$complementoLoteCadastro == null ? other$complementoLoteCadastro != null : !this$complementoLoteCadastro.equals(other$complementoLoteCadastro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : ((Object)$logradouro).hashCode());
        Long $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : ((Object)$cidade).hashCode());
        Long $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : ((Object)$bairro).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        Long $sequenciaEndereco = this.getSequenciaEndereco();
        result = result * 59 + ($sequenciaEndereco == null ? 43 : ((Object)$sequenciaEndereco).hashCode());
        String $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : $exclusaoLogica.hashCode());
        String $tipoImovel = this.getTipoImovel();
        result = result * 59 + ($tipoImovel == null ? 43 : $tipoImovel.hashCode());
        PessoaDTO $pessoaDTO = this.getPessoaDTO();
        result = result * 59 + ($pessoaDTO == null ? 43 : $pessoaDTO.hashCode());
        String $zona = this.getZona();
        result = result * 59 + ($zona == null ? 43 : $zona.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $inscricaoCadastral = this.getInscricaoCadastral();
        result = result * 59 + ($inscricaoCadastral == null ? 43 : $inscricaoCadastral.hashCode());
        String $cidadeCadastro = this.getCidadeCadastro();
        result = result * 59 + ($cidadeCadastro == null ? 43 : $cidadeCadastro.hashCode());
        String $ufCadastro = this.getUfCadastro();
        result = result * 59 + ($ufCadastro == null ? 43 : $ufCadastro.hashCode());
        String $bairroCadastro = this.getBairroCadastro();
        result = result * 59 + ($bairroCadastro == null ? 43 : $bairroCadastro.hashCode());
        String $tipoLogradouroCadastro = this.getTipoLogradouroCadastro();
        result = result * 59 + ($tipoLogradouroCadastro == null ? 43 : $tipoLogradouroCadastro.hashCode());
        String $logradouroCadastro = this.getLogradouroCadastro();
        result = result * 59 + ($logradouroCadastro == null ? 43 : $logradouroCadastro.hashCode());
        String $numeroCadastro = this.getNumeroCadastro();
        result = result * 59 + ($numeroCadastro == null ? 43 : $numeroCadastro.hashCode());
        String $cepCadastro = this.getCepCadastro();
        result = result * 59 + ($cepCadastro == null ? 43 : $cepCadastro.hashCode());
        String $complementoCadastro = this.getComplementoCadastro();
        result = result * 59 + ($complementoCadastro == null ? 43 : $complementoCadastro.hashCode());
        String $complementoLoteCadastro = this.getComplementoLoteCadastro();
        result = result * 59 + ($complementoLoteCadastro == null ? 43 : $complementoLoteCadastro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeralDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", pessoa=" + this.getPessoa() + ", logradouro=" + this.getLogradouro() + ", cidade=" + this.getCidade() + ", bairro=" + this.getBairro() + ", cep=" + this.getCep() + ", numero=" + this.getNumero() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", sequenciaEndereco=" + this.getSequenciaEndereco() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", tipoImovel=" + this.getTipoImovel() + ", pessoaDTO=" + this.getPessoaDTO() + ", zona=" + this.getZona() + ", quadra=" + this.getQuadra() + ", data=" + this.getData() + ", inscricaoCadastral=" + this.getInscricaoCadastral() + ", cidadeCadastro=" + this.getCidadeCadastro() + ", ufCadastro=" + this.getUfCadastro() + ", bairroCadastro=" + this.getBairroCadastro() + ", tipoLogradouroCadastro=" + this.getTipoLogradouroCadastro() + ", logradouroCadastro=" + this.getLogradouroCadastro() + ", numeroCadastro=" + this.getNumeroCadastro() + ", cepCadastro=" + this.getCepCadastro() + ", complementoCadastro=" + this.getComplementoCadastro() + ", complementoLoteCadastro=" + this.getComplementoLoteCadastro() + ")";
    }
}

