/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracaocontabil;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.integracaocontabil.ItemIntegracaoPatrimonial;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialPayload;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="integracaopatrimonial")
public class IntegracaoPatrimonial
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_integracaopatrimonial")
    private Long id;
    private LocalDate dataMovimento;
    @Enumerated(value=EnumType.STRING)
    private SituacaoIntegracaoContabil situacaoIntegracaoPatrimonial;
    @JsonIgnore
    @MetaModelIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="idintegracaopatrimonial", updatable=false, nullable=false)
    private List<ItemIntegracaoPatrimonial> itens = new ArrayList();

    public BigDecimal getValorTotal() {
        return this.itens.stream().map(ItemIntegracaoPatrimonial::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public IntegracaoPatrimonialPayload toPayload() {
        IntegracaoPatrimonialPayload payload = new IntegracaoPatrimonialPayload();
        payload.setId(this.getId());
        payload.setSituacao(this.getSituacaoIntegracaoPatrimonial());
        return payload;
    }

    public IntegracaoPatrimonialContabilidadeDTO toDto() {
        IntegracaoPatrimonialContabilidadeDTO dto = new IntegracaoPatrimonialContabilidadeDTO();
        dto.setId(this.id);
        dto.setDataMovimento(this.dataMovimento);
        dto.setSituacaoIntegracaoPatrimonial(this.situacaoIntegracaoPatrimonial);
        dto.setItens(this.itens.stream().map(ItemIntegracaoPatrimonial::toDto).collect(Collectors.toList()));
        return dto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegracaoPatrimonial)) {
            return false;
        }
        IntegracaoPatrimonial other = (IntegracaoPatrimonial)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegracaoPatrimonial;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public IntegracaoPatrimonial() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public SituacaoIntegracaoContabil getSituacaoIntegracaoPatrimonial() {
        return this.situacaoIntegracaoPatrimonial;
    }

    @Generated
    public List<ItemIntegracaoPatrimonial> getItens() {
        return this.itens;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil situacaoIntegracaoPatrimonial) {
        this.situacaoIntegracaoPatrimonial = situacaoIntegracaoPatrimonial;
    }

    @Generated
    public void setItens(List<ItemIntegracaoPatrimonial> itens) {
        this.itens = itens;
    }

    @Generated
    public String toString() {
        return "IntegracaoPatrimonial(id=" + this.getId() + ", dataMovimento=" + this.getDataMovimento() + ", situacaoIntegracaoPatrimonial=" + this.getSituacaoIntegracaoPatrimonial() + ", itens=" + this.getItens() + ")";
    }
}

