/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.documento.peticao;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.documento.peticao.SituacaoLotePeticao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="triblotepeticao")
@SQLDelete(sql="UPDATE triblotepeticao SET excluido = 'S' WHERE id = ? ")
@Where(clause="excluido = 'N'")
public class LotePeticao
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="SLOTEPETICAO")
    private Long id;
    @NotNull
    private LocalDate dataSimulacao;
    private LocalDate dataGeracao;
    @NotNull
    @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres.")
    private @NotNull @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres.") String usuario;
    @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres.")
    private @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres.") String usuarioGeracao;
    @NotNull
    private SituacaoLotePeticao situacao;
    @NotNull
    @Length(max=4000, message="Tamanho m\u00e1ximo do filtro \u00e9 4000 caracteres.")
    private @NotNull @Length(max=4000, message="Tamanho m\u00e1ximo do filtro \u00e9 4000 caracteres.") String filtro;
    @NotNull
    private Boolean ajuizarDebitos = Boolean.TRUE;
    @NotNull
    private Boolean agruparPorContribuinte = Boolean.FALSE;
    @JsonIgnore
    @OneToMany(mappedBy="lote", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<LotePeticaoItem> itens = new ArrayList();
    @Formula(value="(select sum(tdidv.valor + tdidv.VALORCORRECAO + tdidv.VALORJUROS + tdidv.VALORMULTA) from triblotepeticao tpl  left join TRIBLOTEPETICAOITEM tpli on tpl.ID = tpli.IDLOTEPETICAO  left join TRIBLOTEPETICAOITEMDETALHE tplid on tpli.ID = tplid.IDLOTEPETICAOITEM  left join TRIBDOCUMENTO td on tplid.IDDOCUMENTO = td.IDKEY  left join TRIBDOCUMENTOITEMDIVIDAATIVA  tdidv on td.ENTIDADE = tdidv.ENTIDADE                                             and td.EXERCICIO = tdidv.EXERCICIO                                             and td.TIPODOCUMENTO = tdidv.TIPODOCUMENTO                                             and td.DOCUMENTO = tdidv.DOCUMENTO  where tpl.id = id)")
    private BigDecimal valorTotal;
    @Formula(value="(select count(1) from triblotepeticao tpl  left join TRIBLOTEPETICAOITEM tpli on tpl.ID = tpli.IDLOTEPETICAO  where tpl.id = id)")
    private Integer quantidadePeticoes;
    private Boolean excluido = Boolean.FALSE;

    @JsonIgnore
    public void setChildrenId() {
        this.itens.forEach(item -> {
            item.setLote(this);
            item.setChildrenId();
        });
    }

    @Generated
    public LotePeticao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataSimulacao() {
        return this.dataSimulacao;
    }

    @Generated
    public LocalDate getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioGeracao() {
        return this.usuarioGeracao;
    }

    @Generated
    public SituacaoLotePeticao getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getFiltro() {
        return this.filtro;
    }

    @Generated
    public Boolean getAjuizarDebitos() {
        return this.ajuizarDebitos;
    }

    @Generated
    public Boolean getAgruparPorContribuinte() {
        return this.agruparPorContribuinte;
    }

    @Generated
    public List<LotePeticaoItem> getItens() {
        return this.itens;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Integer getQuantidadePeticoes() {
        return this.quantidadePeticoes;
    }

    @Generated
    public Boolean getExcluido() {
        return this.excluido;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataSimulacao(LocalDate dataSimulacao) {
        this.dataSimulacao = dataSimulacao;
    }

    @Generated
    public void setDataGeracao(LocalDate dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioGeracao(String usuarioGeracao) {
        this.usuarioGeracao = usuarioGeracao;
    }

    @Generated
    public void setSituacao(SituacaoLotePeticao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setFiltro(String filtro) {
        this.filtro = filtro;
    }

    @Generated
    public void setAjuizarDebitos(Boolean ajuizarDebitos) {
        this.ajuizarDebitos = ajuizarDebitos;
    }

    @Generated
    public void setAgruparPorContribuinte(Boolean agruparPorContribuinte) {
        this.agruparPorContribuinte = agruparPorContribuinte;
    }

    @Generated
    public void setItens(List<LotePeticaoItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setQuantidadePeticoes(Integer quantidadePeticoes) {
        this.quantidadePeticoes = quantidadePeticoes;
    }

    @Generated
    public void setExcluido(Boolean excluido) {
        this.excluido = excluido;
    }

    @Generated
    public String toString() {
        return "LotePeticao(id=" + this.getId() + ", dataSimulacao=" + this.getDataSimulacao() + ", dataGeracao=" + this.getDataGeracao() + ", usuario=" + this.getUsuario() + ", usuarioGeracao=" + this.getUsuarioGeracao() + ", situacao=" + this.getSituacao() + ", filtro=" + this.getFiltro() + ", ajuizarDebitos=" + this.getAjuizarDebitos() + ", agruparPorContribuinte=" + this.getAgruparPorContribuinte() + ", itens=" + this.getItens() + ", valorTotal=" + this.getValorTotal() + ", quantidadePeticoes=" + this.getQuantidadePeticoes() + ", excluido=" + this.getExcluido() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LotePeticao)) {
            return false;
        }
        LotePeticao other = (LotePeticao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LotePeticao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

