/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteAgrupamentoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteDTO;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.repository.CalculoGeracaoLoteCustomRepository;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CalculoGeracaoLoteRepositoryImpl
implements CalculoGeracaoLoteCustomRepository {
    private static final String LOAD_ITENS_LOTE_IMPRESSAO = "br/com/elotech/tributos/calculo/repository/load-cadastro-geracao-lote-impressao.sql";
    private static final String AND = " and ";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CalculoGeracaoLoteRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Set<LoteItemDTO> loadItensLoteImpressao(CalculoGeracaoLoteDTO calculoGeracaoLote) {
        StringBuilder select = new StringBuilder();
        StringBuilder where = new StringBuilder();
        StringBuilder order = new StringBuilder();
        if (!calculoGeracaoLote.getFiltros().isEmpty()) {
            where.append(AND).append(calculoGeracaoLote.getFiltros().stream().map(CalculoGeracaoLoteFiltroDTO::generateFiltro).collect(Collectors.joining(AND)));
        }
        if (!calculoGeracaoLote.getOrdenacoes().isEmpty()) {
            order.append(" ORDER BY ").append(calculoGeracaoLote.getOrdenacoes().stream().map(calculoGeracaoLoteOrdenacaoDTO -> calculoGeracaoLoteOrdenacaoDTO.getCampo().generateSelect()).collect(Collectors.joining(",")));
        }
        if (!calculoGeracaoLote.getAgrupamentos().isEmpty()) {
            select.append(",").append(calculoGeracaoLote.getAgrupamentos().stream().sorted(Comparator.comparing(CalculoGeracaoLoteAgrupamentoDTO::getOrdemAgrupamento)).map(calculoGeracaoLoteAgrupamentoDTO -> String.format("concat('%s: ', cast(%s as varchar(4000)))", calculoGeracaoLoteAgrupamentoDTO.getCampo().getDescricao(), calculoGeracaoLoteAgrupamentoDTO.getCampo().generateSelect())).collect(Collectors.joining("||' - '|| "))).append(" agrupamento");
        }
        String sql = String.format(FileUtils.readResourceAsString((String)LOAD_ITENS_LOTE_IMPRESSAO), select.toString(), where.toString(), order.toString());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("IDCALCULO", (Object)calculoGeracaoLote.getIdCalculo());
        List result = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemDTO.class));
        return new HashSet<LoteItemDTO>(result);
    }
}

