/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.exception.JobParameterSerializationException;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.utils.TenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ConsultaDebitoJobListener
extends JobExecutionListenerSupport {
    private static final String USER_ID = "user-id";
    private static final String USER_AISE = "user-aise";
    private static final String CONSULTA_DEBITO = "consultaDebito";
    private final NotificacaoClient notificacaoClient;
    private final ObjectMapper objectMapper;
    private final FormaPagamentoService formaPagamentoService;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;

    public ConsultaDebitoJobListener(NotificacaoClient notificacaoClient, ObjectMapper objectMapper, FormaPagamentoService formaPagamentoService, ConsultaDebitoBatchService consultaDebitoBatchService) {
        this.notificacaoClient = notificacaoClient;
        this.objectMapper = objectMapper;
        this.formaPagamentoService = formaPagamentoService;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        FiltroConsultaDebitoDTO filtro = this.getFiltroFromJobParameters(jobExecution.getJobParameters());
        this.adicionaHeaderNoSecurityContext(jobExecution.getJobParameters());
        ConsultaDebito consultaDebito = (ConsultaDebito)this.consultaDebitoBatchService.findById((Serializable)jobExecution.getJobParameters().getLong("idConsulta")).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a consulta de d\u00e9bitos."));
        consultaDebito.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.consultaDebitoBatchService.save((EloEntity)consultaDebito, null);
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        jobExecution.getExecutionContext().put(CONSULTA_DEBITO, (Object)consultaDebito);
        jobExecution.getExecutionContext().put("filtro", (Object)filtro);
        jobExecution.getExecutionContext().put("formaPagamentoPadrao", (Object)formaPagamentoPadrao);
        this.enviaNotificacaoInicio(jobExecution);
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        this.enviaNotificacaoFim(jobExecution);
    }

    private FiltroConsultaDebitoDTO getFiltroFromJobParameters(JobParameters jobParameters) {
        try {
            return (FiltroConsultaDebitoDTO)this.objectMapper.readValue(Objects.requireNonNull(jobParameters.getString("filtro")), FiltroConsultaDebitoDTO.class);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao desserializar o filtro no par\u00e2metro do job", (Throwable)e);
        }
    }

    private void adicionaHeaderNoSecurityContext(JobParameters jobParameters) {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.addHeader("USER_AISE", (Object)Objects.requireNonNull(jobParameters.getString(USER_AISE)));
        mockHttpServletRequest.addHeader(USER_ID, (Object)Objects.requireNonNull(jobParameters.getString(USER_ID)));
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes((HttpServletRequest)mockHttpServletRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
    }

    private void enviaNotificacaoInicio(JobExecution jobExecution) {
        String userId = jobExecution.getJobParameters().getString(USER_ID);
        Notificacao notificacao = Notificacao.builder().text("Gera\u00e7\u00e3o da consulta de d\u00e9bitos foi iniciado").title("Foi iniciada a gera\u00e7\u00e3o da consulta de d\u00e9bitos").time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(Objects.requireNonNull(userId)));
    }

    private void enviaNotificacaoFim(JobExecution jobExecution) {
        ConsultaDebito consultaDebito;
        String userId = jobExecution.getJobParameters().getString(USER_ID);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            consultaDebito = (ConsultaDebito)jobExecution.getExecutionContext().get(CONSULTA_DEBITO);
            notificacao.text("Gera\u00e7\u00e3o da consulta dos d\u00e9bitos finalizada com sucesso").title(String.format("Gera\u00e7\u00e3o da consulta dos d\u00e9bitos: %d finalizada com sucesso", consultaDebito.getId())).metadata("jobType", (Object)JobType.CONSULTA_DEBITO.getTipo()).metadata(CONSULTA_DEBITO, (Object)consultaDebito);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            consultaDebito = (ConsultaDebito)jobExecution.getExecutionContext().get(CONSULTA_DEBITO);
            notificacao.text("Erro na consulta dos d\u00e9bitos").title(String.format("N\u00e3o foi poss\u00edvel realizar a consulta dos d\u00e9bitos %d.", consultaDebito.getId())).metadata("jobType", (Object)JobType.CONSULTA_DEBITO.getTipo()).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), UUID.fromString(userId));
    }
}

