/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoloteimpressaogeracaocarne;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Transactional
public class CalculoGeracaoCarneJobListener
extends JobExecutionListenerSupport {
    private static final String USER_ID = "user-id";
    private static final String USER_AISE = "user-aise";
    private static final String ID = "idCalculo";
    private static final String JOB_TYPE = "jobType";
    private static final String CALCULO_GERACAO_CARNE = JobType.CALCULO_GERACAO_CARNE.getTipo();
    private final NotificacaoClient notificacaoClient;
    private final CalculoService calculoService;
    private final CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;

    public CalculoGeracaoCarneJobListener(NotificacaoClient notificacaoClient, CalculoService calculoService, CalculoLoteImpressaoItemService calculoLoteImpressaoItemService) {
        this.notificacaoClient = notificacaoClient;
        this.calculoService = calculoService;
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        this.adicionaHeaderNoSecurityContext(jobExecution.getJobParameters());
        String userId = jobExecution.getJobParameters().getString(USER_ID);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        Calculo calculo = this.calculoService.findCalculoById(idCalculo);
        this.calculoLoteImpressaoItemService.validaGeracaoCarneBatch(calculo);
        calculo.setBatchJobExecutionCarne(BatchJobExecution.of((JobExecution)jobExecution));
        calculo.setSituacao(SituacaoCalculo.GERANDO_CARNE);
        this.calculoService.save((EloEntity)calculo, null);
        Notificacao notificacao = Notificacao.builder().text("Gera\u00e7\u00e3o dos carn\u00eas iniciada.").title(String.format("Foi iniciada a gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)CALCULO_GERACAO_CARNE).metadata(ID, (Object)idCalculo).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(userId));
    }

    private void adicionaHeaderNoSecurityContext(JobParameters jobParameters) {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.addHeader(USER_AISE, (Object)jobParameters.getString(USER_AISE));
        mockHttpServletRequest.addHeader(USER_ID, (Object)jobParameters.getString(USER_ID));
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes((HttpServletRequest)mockHttpServletRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        String userId = jobExecution.getJobParameters().getString(USER_ID);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        Calculo calculo = this.calculoService.findCalculoById(idCalculo);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            calculo.setSituacao(SituacaoCalculo.CARNE_GERADO);
            this.calculoService.save((EloEntity)calculo, null);
            notificacao.text("Gera\u00e7\u00e3o dos carn\u00eas finalizada com sucesso.").title(String.format("A gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d foi finalizada com sucesso.", idCalculo)).metadata(JOB_TYPE, (Object)CALCULO_GERACAO_CARNE).metadata(ID, (Object)idCalculo);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            calculo.setSituacao(SituacaoCalculo.ERRO_GERACAO_CARNE);
            this.calculoService.save((EloEntity)calculo, null);
            notificacao.text("Erro na gera\u00e7\u00e3o dos carn\u00eas.").title(String.format("N\u00e3o foi poss\u00edvel realizar a gera\u00e7\u00e3o dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo)).metadata(JOB_TYPE, (Object)CALCULO_GERACAO_CARNE).metadata(ID, (Object)idCalculo).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), UUID.fromString(userId));
    }
}

