Select a.TipoCadastro,
       a.CadastroGeral,
       a.idKey as idCadastro,
       a.cnpj_cpf as cpfCnpj,
       case
         when a.tipopessoa = 'J' then
          'Jurídica'
         else
          'Física'
       end as tipoPessoa,
       a.nome,
       a.pessoa,
       a.VinculoDescricao,
       a.tipovinculo,
       a.principal,
       coalesce(sitimob.descricao, sitmob.descricao, 'OK') as situacao
  from (Select a.TipoCadastro,
               a.CadastroGeral,
               cg.idkey,
               b.cnpj_cpf,
               b.tipopessoa,
               b.nome,
               b.pessoa,
               case when cg.tipoCadastro = 2 
                    then 'SOCIO'
                    else tv.descricao
               end as VinculoDescricao,
               tv.tipovinculo,
               case when a.principal = 'S' 
                    then 1
                    else 0
               end as principal
          From tribViewProprietario a
          left outer join tribCadastroGeral cg on a.tipocadastro = cg.tipocadastro
                                              and a.cadastrogeral = cg.cadastrogeral
          left outer join pessoa b on a.pessoa = b.pessoa
          left outer join pessoa pcad on pcad.pessoa = cg.pessoa
          left outer join tribVinculo tv on a.vinculo = tv.vinculo
                                        and tv.tipovinculo <> 5
         where cg.ExclusaoLogica = 'N'
           :filtroRastreamento 
           and a.tipocadastro in (:tiposCadastro)
        union all
        select cg.TipoCadastro,
               cg.CadastroGeral,
               cg.idkey,
               b.cnpj_cpf,
               b.tipopessoa,
               b.nome,
               b.pessoa,
               'PROPRIETARIO' as VinculoDescricao,
               1 as tipovinculo,
               1 as principal
          from tribCadastroGeral cg
         inner join pessoa b on cg.pessoa = b.pessoa
          left outer join pessoa pcad on pcad.pessoa = cg.pessoa
         where cg.ExclusaoLogica = 'N'
           and cg.tipocadastro = 2
           :filtroRastreamento ) a
  left outer join tribmobiliariosituacao mobsit on a.tipocadastro = mobsit.tipocadastro
                                               and a.cadastrogeral = mobsit.cadastrogeral
                                               and mobsit.atual = 'S'
  left outer join tribsituacaomobiliario sitmob on sitmob.situacaomobiliario = mobsit.situacaomobiliario
  left outer join tribimobiliariosituacao imobsit on a.tipocadastro = imobsit.tipocadastro
                                                 and a.cadastrogeral = imobsit.cadastrogeral
                                                 and imobsit.atual = 'S'
  left outer join tribsituacaoimobiliario sitimob on sitimob.situacaoimobiliario = imobsit.situacaoimobiliario
 order by tipocadastro, cadastrogeral, pessoa
