 SELECT
    deb.IDDEBITO,
	dpr.ENTIDADE,
 	dpr.EXERCICIO,
 	dpr.TIPOCADASTRO,
 	dpr.CADASTROGERAL,
 	dpr.GUIARECOLHIMENTO as DIVIDA,
 	dpr.SUBDIVIDA,
 	dpr.PARCELA,
 	sum(dpr.VALOR) as VALOR,
 	p.SITUACAOLEGAL
 	FROM TRIBDEBITOPARCELARECEITA dpr
 	INNER JOIN TRIBDEBITO deb
         on dpr.ENTIDADE = deb.ENTIDADE
         and dpr.EXERCICIO = deb.EXERCICIO
         and dpr.TIPOCADASTRO = deb.TIPOCADASTRO
         and dpr.CADASTROGERAL = deb.CADASTROGERAL
         and dpr.GUIARECOLHIMENTO = deb.GUIARECOLHIMENTO
         and dpr.SUBDIVIDA = deb.SUBDIVIDA
 	INNER JOIN TRIBDEBITOPARCELA p
 		ON p.entidade = dpr.entidade
 		AND p.EXERCICIO = dpr.EXERCICIO
        AND p.TIPOCADASTRO = dpr.TIPOCADASTRO
 		AND p.CADASTROGERAL = dpr.CADASTROGERAL
 		AND p.GUIARECOLHIMENTO = dpr.GUIARECOLHIMENTO
 		AND p.SUBDIVIDA = dpr.SUBDIVIDA
 		AND p.PARCELA = dpr.PARCELA
 	INNER JOIN TRIBSITUACAOPARCELA s
 		ON s.SITUACAOPARCELA = p.SITUACAODEBITO
 	INNER JOIN TRIBTIPOSITUACAOPARCELA ts
 		ON ts.TIPOSITUACAOPARCELA = s.TIPOSITUACAOPARCELA
	WHERE dpr.entidade = :entidade
		AND dpr.TIPOCADASTRO = :tipoCadastro
		AND dpr.VALOR > 0
		AND ts.TIPO = 'A'
		AND p.SITUACAOLEGAL IN (:situacoesLegais)
		$[FILTROS]
	GROUP BY
	    deb.IDDEBITO,
		dpr.ENTIDADE,
	 	dpr.EXERCICIO,
	 	dpr.TIPOCADASTRO,
	 	dpr.CADASTROGERAL,
	 	dpr.GUIARECOLHIMENTO,
	 	dpr.SUBDIVIDA,
	 	dpr.PARCELA,
	 	p.SITUACAOLEGAL
	ORDER BY
	    dpr.ENTIDADE,
        dpr.EXERCICIO,
        dpr.TIPOCADASTRO,
        dpr.CADASTROGERAL,
        dpr.GUIARECOLHIMENTO,
        dpr.SUBDIVIDA,
        dpr.PARCELA
	 	