/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ParamGeraDebitoLaudoDTO;
import br.com.elotech.tributos.dto.ValoresLaudoDTO;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.LaudoAvaliacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.GeraLaudoAvaliacaoEnvio;
import br.com.elotech.tributos.ws.domain.GeraLaudoAvaliacaoResposta;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseLaudoAvaliacaoServiceRest
implements LaudoAvaliacaoService {
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;
    private final ParametroGeralService parametroGeralService;
    private final AiseDebitoService debitoService;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final DocumentoService documentoService;
    private static final Long PRAZO_PAGAMENTO_PADRAO = 30L;

    public AiseLaudoAvaliacaoServiceRest(AiseLoginServiceRest aiseLoginServiceRest, RestTemplate restTemplate, TributosProperties tributosProperties, ParametroGeralService parametroGeralService, AiseDebitoService debitoService, ExercicioService exercicioService, EntidadeService entidadeService, EntidadeTributacaoService entidadeTributacaoService, DocumentoService documentoService) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.parametroGeralService = parametroGeralService;
        this.debitoService = debitoService;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.documentoService = documentoService;
    }

    public GeraLaudoAvaliacaoResposta geraLaudoAvaliacao(Long cadastroGeral) {
        return this.geraLaudoAvaliacao(new GeraLaudoAvaliacaoEnvio(cadastroGeral));
    }

    private GeraLaudoAvaliacaoResposta geraLaudoAvaliacao(DocumentoDTO laudoDocumentoDto) {
        return this.geraLaudoAvaliacao(new GeraLaudoAvaliacaoEnvio(laudoDocumentoDto));
    }

    public GeraLaudoAvaliacaoResposta geraLaudoAvaliacao(GeraLaudoAvaliacaoEnvio geraLaudoAvaliacaoEnvio) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((Object)geraLaudoAvaliacaoEnvio, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tcertidao/gerarLaudoAvaliacao/", HttpMethod.POST, entity, GeraLaudoAvaliacaoResposta.class, new Object[0]);
        return (GeraLaudoAvaliacaoResposta)response.getBody();
    }

    public ValoresLaudoDTO calcularValorLaudo(List<Long> listCadastroGeral) {
        BigDecimal valorUnitarioLaudo = this.parametroValorLaudoAvaliacaoItbi();
        ValoresLaudoDTO valoresLaudo = new ValoresLaudoDTO();
        valoresLaudo.setValorUnitario(valorUnitarioLaudo);
        valoresLaudo.setValorTotal(valorUnitarioLaudo.multiply(BigDecimal.valueOf(listCadastroGeral.size())));
        return valoresLaudo;
    }

    public GerarDebitoResponseDTO gerarDebito(ParamGeraDebitoLaudoDTO param) {
        Long entidade = this.entidadeService.findEntidadePrincipal().getId();
        Long exercicio = this.exercicioService.getExercicio();
        GerarDebitoRequestDTO gerarDebitoRequestDTO = new GerarDebitoRequestDTO();
        gerarDebitoRequestDTO.setTipoCadastro(param.getTipoCadastroRequerente());
        gerarDebitoRequestDTO.setCadastroGeral(param.getCadastroGeralRequerente());
        gerarDebitoRequestDTO.setExercicio(exercicio);
        gerarDebitoRequestDTO.setEntidade(entidade);
        gerarDebitoRequestDTO.setGuiaRecolhimento(this.parametroGuiaLaudoAvaliacaoItbi());
        gerarDebitoRequestDTO.setReceita(this.parametroReceitaLaudoAvaliacaoItbi());
        gerarDebitoRequestDTO.setDataLancamento(LocalDate.now());
        gerarDebitoRequestDTO.setDataVencimento(LocalDate.now().plusDays(this.parametroDiasPrazoPagamento(entidade, exercicio)));
        gerarDebitoRequestDTO.setValorPrincipal(param.getValorTotalLaudos());
        gerarDebitoRequestDTO.setObservacao(param.getObservacao());
        gerarDebitoRequestDTO.setTelaOrigemDebito("ITBI Online");
        return this.debitoService.geraDebito(gerarDebitoRequestDTO);
    }

    private BigDecimal parametroValorLaudoAvaliacaoItbi() {
        BigDecimal valorUnitario = this.parametroGeralService.getParamValueAsBigDecimal(ParametroGeralEnum.AVALIACAO_ITBI_VALOR, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (valorUnitario == null) {
            return BigDecimal.valueOf(0L);
        }
        return valorUnitario;
    }

    private Long parametroGuiaLaudoAvaliacaoItbi() {
        Long guiaAvaliacaoItbi = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.AVALIACAO_ITBI_GUIA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (guiaAvaliacaoItbi == null) {
            throw new ParametroNaoEncontradoException(ParametroGeralEnum.AVALIACAO_ITBI_GUIA.getValue());
        }
        return guiaAvaliacaoItbi;
    }

    private String parametroReceitaLaudoAvaliacaoItbi() {
        String receitaAvaliacaoItbi = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.AVALIACAO_ITBI_RECEITA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (receitaAvaliacaoItbi == null) {
            throw new ParametroNaoEncontradoException(ParametroGeralEnum.AVALIACAO_ITBI_RECEITA.getValue());
        }
        return receitaAvaliacaoItbi;
    }

    private Long parametroDiasPrazoPagamento(Long entidade, Long exercicio) {
        ParametroItbi parametroItbi;
        Long prazoPagamento = PRAZO_PAGAMENTO_PADRAO;
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio);
        if (entidadeTributacao != null && (parametroItbi = entidadeTributacao.getParametroITBI()) != null && parametroItbi.getPrazoPagamento() > 0L) {
            prazoPagamento = parametroItbi.getPrazoPagamento();
        }
        return prazoPagamento;
    }

    public List<DocumentoDTO> gerarDocumentoLoteLaudoAvaliacao(List<DocumentoDTO> listCadastro) {
        return listCadastro.stream().map(arg_0 -> this.geraLaudoAvaliacao(arg_0)).map(arg_0 -> this.getDocumento(arg_0)).collect(Collectors.toList());
    }

    private DocumentoDTO getDocumento(GeraLaudoAvaliacaoResposta laudoAvaliacao) {
        Long entidade = this.entidadeService.findEntidadePrincipal().getId();
        return this.documentoService.getDocumentoDTO(entidade, laudoAvaliacao.getExercicio(), laudoAvaliacao.getTipoDocumento(), laudoAvaliacao.getDocumento());
    }
}

