/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.tributos.security.AuthenticationClientUnico;
import br.com.elotech.unico.client.LogradouroFeignClient;
import br.com.elotech.unico.client.dto.LogradouroDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogradouroClientUnico {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogradouroClientUnico.class);
    private static final String MSGAUTENTICADOSUCESSO = "Autenticado no \u00fanico com sucesso";
    private final LogradouroFeignClient logradouroFeignClient;
    private final AuthenticationClientUnico authClient;

    public LogradouroClientUnico(LogradouroFeignClient logradouroFeignClient, AuthenticationClientUnico authenticationClient) {
        this.logradouroFeignClient = logradouroFeignClient;
        this.authClient = authenticationClient;
    }

    public LogradouroDTO saveLogradouro(LogradouroDTO logradouroDTO) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            return this.logradouroFeignClient.saveLogradouro(token, logradouroDTO);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao salvar o logradouro no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir o novo logradouro no \u00fanico", (Throwable)ex);
        }
    }
}

