/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoLegal;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.DebitoCdaAgrupadorDTO;
import br.com.elotech.tributos.dto.documento.cda.DebitoGeracaoCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoteCdaService
extends CrudService<LoteCda, Long> {
    private static final Integer MAX_LENGTH = 4000;
    private final DebitoRepository debitoRepository;
    private final ContextService contextService;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final LoteCdaRepository loteCdaRepository;
    private final LoteCdaItemRepository loteCdaItemRepository;
    private final CadastroGeralService cadastroGeralService;

    LoteCdaService(DebitoRepository debitoRepository, ContextService contextService, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, LoteCdaRepository loteCdaRepository, LoteCdaItemRepository loteCdaItemRepository, CadastroGeralService cadastroGeralService) {
        this.debitoRepository = debitoRepository;
        this.cadastroGeralService = cadastroGeralService;
        this.contextService = contextService;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.loteCdaRepository = loteCdaRepository;
        this.loteCdaItemRepository = loteCdaItemRepository;
    }

    protected void beforeSave(LoteCda entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    private List<LoteCdaItem> agruparCdas(List<DebitoGeracaoCdaDTO> debitos, Boolean incluiTodosProprietarios) {
        Map<DebitoCdaAgrupadorDTO, List<DebitoGeracaoCdaDTO>> agrupadosPorCadastro = debitos.stream().collect(Collectors.groupingBy(DebitoGeracaoCdaDTO::toDebitoCdaAgrupador));
        ArrayList<LoteCdaItem> itemsGerados = new ArrayList<LoteCdaItem>();
        agrupadosPorCadastro.forEach((agrupador, debitosAgrupadosPorCadastro) -> {
            if (agrupador.getCdaIndividual().booleanValue()) {
                Map<Long, List<DebitoGeracaoCdaDTO>> debitosAgrupadosPorDebito = debitosAgrupadosPorCadastro.stream().collect(Collectors.groupingBy(DebitoGeracaoCdaDTO::getIdDebito));
                List cdas = debitosAgrupadosPorDebito.values().stream().map(debitoAgrupadoPorDebito -> this.debitoToCdaItem(agrupador, debitoAgrupadoPorDebito, incluiTodosProprietarios)).collect(Collectors.toList());
                itemsGerados.addAll(cdas);
            } else {
                LoteCdaItem cda = this.debitoToCdaItem(agrupador, debitosAgrupadosPorCadastro, incluiTodosProprietarios);
                itemsGerados.add(cda);
            }
        });
        return itemsGerados;
    }

    private void calcularAcrescimosSimulacao(LocalDate dataReferencia, List<DebitoGeracaoCdaDTO> debitos, Long entidade) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        debitos.forEach(debito -> {
            AcrescimoDTO acrescimo = new AcrescimoDTO();
            acrescimo.setEntidade(entidade);
            acrescimo.setExercicio(debito.getExercicioDebito());
            acrescimo.setDataLancamento(debito.getDataLancamento());
            acrescimo.setDataPrimeiraParcela(debito.getDataPrimeiraParcela());
            acrescimo.setDataReferencia(dataReferencia);
            acrescimo.setDataVencimento(debito.getDataVencimento());
            acrescimo.setDataVencimentoOriginal(debito.getDataVencimento());
            acrescimo.setFormaCorrecao(debito.getFormaCorrecao());
            acrescimo.setParcelado(Boolean.valueOf(debito.getParcelado() != false || debito.getReparcelado() != false));
            acrescimo.setSituacaoLegal(SituacaoLegal.fromValue((Integer)debito.getSituacaoLegal().intValue()));
            acrescimo.setTributo(debito.getTributo());
            acrescimo.setValor(debito.getValor());
            acrescimo.setFormaPagamento(formaPagamento.getId());
            DividaDTO divida = new DividaDTO();
            divida.setId(debito.getIdDivida());
            divida.setExercicio(debito.getExercicioDebito());
            divida.setDivida(debito.getDivida());
            divida.setEntidade(entidade);
            acrescimo.setDivida(divida);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo);
            debito.setValor(acrescimo.getValor());
            debito.setValorJuros(acrescimo.getValorJuros());
            debito.setValorMulta(acrescimo.getValorMulta());
            debito.setValorCorrecao(acrescimo.getValorCorrecao());
        });
    }

    public void calcularAcrescimosGeracaoCda(LocalDate dataReferencia, List<LoteCdaItem> itens, Long entidade) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        itens.forEach(cda -> cda.getItemDetalhes().forEach(itemDetalhe -> {
            AcrescimoDTO acrescimo = AcrescimoDTO.of((LoteCdaItemDetalhe)itemDetalhe, (Long)formaPagamento.getId());
            acrescimo.setEntidade(entidade);
            acrescimo.setDataReferencia(dataReferencia);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo);
            itemDetalhe.setValor(acrescimo.getValor());
            itemDetalhe.setValorMulta(acrescimo.getValorMulta());
            itemDetalhe.setValorJuros(acrescimo.getValorJuros());
            itemDetalhe.setValorCorrecao(acrescimo.getValorCorrecao());
        }));
    }

    public LoteCdaResumoDTO getResumo(Long id) {
        return (LoteCdaResumoDTO)this.loteCdaRepository.getResumo(id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o lote com id: %d", id)));
    }

    public Page<LoteCdaItem> searchItens(Long id, String search, Pageable pageable) {
        String idClause = String.format("lote.id==%d", id);
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LoteCdaItem.class, (String)searchWithIdClause);
        return this.loteCdaItemRepository.findAll(specification, pageable);
    }

    public LoteCdaResumoDTO gerarSimulacao(GeracaoLoteCdaDTO geracaoDTO) {
        Long entidade = this.contextService.getEntidadePrincipal();
        LocalDate dataReferencia = LocalDate.now();
        List debitos = this.debitoRepository.findDebitosGeracaoCDA(geracaoDTO, entidade);
        if (debitos.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum d\u00e9bito para gerar uma certid\u00e3o de d\u00edvida ativa com esses filtros.");
        }
        this.calcularAcrescimosSimulacao(dataReferencia, debitos, entidade);
        AtomicLong sequencia = new AtomicLong(1L);
        List cdas = this.agruparCdas(debitos, geracaoDTO.getIncluiTodosProprietarios()).stream().filter(cda -> cda.getValorTotal().compareTo(geracaoDTO.getValorMinimoCertidao()) >= 0).peek(cda -> cda.setSequencia(Long.valueOf(sequencia.getAndIncrement()))).collect(Collectors.toList());
        if (cdas.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel gerar CDA com valor maior ou igual ao valor m\u00ednimo configurado.");
        }
        LoteCda loteCda = new LoteCda();
        loteCda.setDataSimulacao(dataReferencia);
        loteCda.setSituacao(SituacaoLoteCda.GERANDO_SIMULACAO);
        loteCda.setUsuario(SecurityUtils.getUserAise());
        loteCda.setFiltro(geracaoDTO.filtro().substring(0, Math.min(geracaoDTO.filtro().length(), MAX_LENGTH)));
        loteCda.setItens(cdas);
        loteCda.setSituacao(SituacaoLoteCda.SIMULACAO_GERADA);
        return LoteCdaResumoDTO.of((LoteCda)((LoteCda)this.save((EloEntity)loteCda, null)));
    }

    private LoteCdaItem debitoToCdaItem(DebitoCdaAgrupadorDTO agrupador, List<DebitoGeracaoCdaDTO> debitos, Boolean incluiTodosProprietarios) {
        LoteCdaItem gerado = new LoteCdaItem();
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(agrupador.getIdCadastroGeral());
        cadastroGeral.setCadastroGeral(agrupador.getCadastroGeral());
        cadastroGeral.setTipoCadastro(TipoCadastro.fromValue((Long)agrupador.getTipoCadastro()));
        gerado.setCadastroGeral(cadastroGeral);
        List detalhes = debitos.stream().map(debito -> {
            LoteCdaItemDetalhe loteCdaItemDetalhe = new LoteCdaItemDetalhe();
            loteCdaItemDetalhe.setValor(debito.getValor());
            loteCdaItemDetalhe.setValorJuros(debito.getValorJuros());
            loteCdaItemDetalhe.setValorMulta(debito.getValorMulta());
            loteCdaItemDetalhe.setValorCorrecao(debito.getValorCorrecao());
            DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
            debitoParcelaTributo.setId(debito.getIdDebitoParcelaTributo());
            loteCdaItemDetalhe.setParcelaTributo(debitoParcelaTributo);
            return loteCdaItemDetalhe;
        }).collect(Collectors.toList());
        gerado.getItemDetalhes().addAll(detalhes);
        gerado.getItemPessoas().addAll(this.getProprietarios(cadastroGeral, incluiTodosProprietarios).stream().map(pessoa -> LoteCdaItemPessoa.of((Pessoa)pessoa, (LoteCdaItem)gerado)).collect(Collectors.toList()));
        return gerado;
    }

    private List<Pessoa> getProprietarios(CadastroGeral cadastroGeral, Boolean incluiTodosProprietarios) {
        if (incluiTodosProprietarios.booleanValue()) {
            return this.cadastroGeralService.getTodosResponsaveis(cadastroGeral);
        }
        return Collections.singletonList(this.cadastroGeralService.getResponsavelPrincipal(cadastroGeral));
    }

    public List<BigDecimal> getDebitoParcelaTributoInvalidoFromLoteCda(Long id) {
        return this.loteCdaRepository.findDebitoParcelaTributoInvalidoFromLoteCda(id);
    }

    protected void beforeDelete(LoteCda entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)entity.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover lote com situa\u00e7\u00e3o diferente de %s", SituacaoLoteCda.SIMULACAO_GERADA.getDescricao()));
        }
    }
}

