/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;

@Service
public class LivroDividaAtivaJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job livroDividaAtivaBatchJob;
    private final ParametroGeralService parametroGeralService;
    private final ContextService contextService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;

    public LivroDividaAtivaJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, Job livroDividaAtivaBatchJob, ParametroGeralService parametroGeralService, ContextService contextService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.livroDividaAtivaBatchJob = livroDividaAtivaBatchJob;
        this.parametroGeralService = parametroGeralService;
        this.contextService = contextService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
    }

    public JobExecution startJob(FiltroGeraLivroDTO filtro) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        String filtroString = this.objectMapper.writeValueAsString((Object)filtro);
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.CREATE_LIVRO_DIVIDA_ATIVA.getTipo()).stream().anyMatch(job -> filtroString.equals(job.getJobParameters().getString("filtro")));
        if (existeJobNaoFinalizadoComMesmoFiltro.booleanValue()) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        Boolean englobaDebitos = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.ENGLOBA_DEBITO_DIVIDA_ATIVA).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
        String parametroInscricaoPorParcela = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_INSCRICAO_DIVIDA_ATIVA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Livro livroCriado = this.geraLivroDividaAtivaBatchService.createLivroFromFiltro(filtro, englobaDebitos);
        String livroId = this.objectMapper.writeValueAsString((Object)livroCriado.getId());
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addString("filtro", filtroString);
        jobParametersBuilder.addString("user-aise", SecurityUtils.getUserAise());
        jobParametersBuilder.addString("user-id", SecurityUtils.getUserId().toString());
        jobParametersBuilder.addString("inscricaoPorParcela", parametroInscricaoPorParcela);
        jobParametersBuilder.addString("livroId", livroId);
        jobParametersBuilder.addLong("entidade", this.contextService.getEntidadePrincipal());
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.livroDividaAtivaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

