/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import org.springframework.stereotype.Service;

@Service
public class SimulacaoAcrescimoService {
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;

    public SimulacaoAcrescimoService(CalculoAcrescimoService calculoAcrescimoService, EntidadeService entidadeService, ExercicioService exercicioService) {
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
    }

    public AcrescimoDTO simular(AcrescimoDTO params) {
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        Long exercicio = this.exercicioService.getExercicio();
        params.setExercicio(exercicio);
        params.setEntidade(entidade.getId());
        return this.calculoAcrescimoService.calculaAcrescimos(params);
    }
}

