/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.repository.ParametroEntidadeExercicioRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ParametroEntidadeExercicioService
extends CrudService<ParametroEntidadeExercicio, Long> {
    private final ParametroEntidadeExercicioRepository parametroEntidadeExercicioRepository;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;

    public ParametroEntidadeExercicioService(ParametroEntidadeExercicioRepository parametroEntidadeExercicioRepository, EntidadeService entidadeService, ExercicioService exercicioService) {
        this.parametroEntidadeExercicioRepository = parametroEntidadeExercicioRepository;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
    }

    public ParametroEntidadeExercicio findByKey(Long entidade, Long exercicio, String modulo, String parametro) {
        return this.parametroEntidadeExercicioRepository.findByKey(entidade, exercicio, modulo, parametro);
    }

    public ParametroEntidadeExercicio findByModuloAndParametro(String modulo, String parametro) {
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return this.parametroEntidadeExercicioRepository.findByKey(entidade.getId(), exercicio, modulo, parametro);
    }

    public Optional<ParametroEntidadeExercicio> findByModuloAndParametro(ModuloEnum modulo, ParametroEntidadeExercicioEnum parametro) {
        return Optional.ofNullable(this.findByModuloAndParametro(modulo.getValue(), parametro.getValue()));
    }
}

